<?php

// Este script actualiza el company_id del usuario "user3" para que pertenezca a la compañía 3

// Cargar el entorno de Laravel
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\User;
use Illuminate\Support\Facades\Log;

// Buscar al usuario "user3" (ID: 10)
$user = User::find(10);

if (!$user) {
    Log::error('No se encontró el usuario con ID 10 (user3)');
    echo "Error: No se encontró el usuario con ID 10 (user3)\n";
    exit(1);
}

// Guardar el company_id actual para el registro
$oldCompanyId = $user->company_id;

// Actualizar el company_id a 3
$user->company_id = 3;
$user->save();

// Registrar la actualización
Log::info('Se actualizó el company_id del usuario: ' . $user->name . ' (ID: ' . $user->id . ') de ' . $oldCompanyId . ' a 3');
echo "Se actualizó el company_id del usuario: " . $user->name . " (ID: " . $user->id . ") de " . $oldCompanyId . " a 3\n";

echo "Actualización completada con éxito.\n";
