<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use Illuminate\Support\Facades\DB;

// Verificar si la migración ya existe en la tabla migrations
$migrationExists = DB::table('migrations')
    ->where('migration', '2025_09_05_195517_create_leaves_table')
    ->exists();

if (!$migrationExists) {
    // Insertar la migración en la tabla migrations
    DB::table('migrations')->insert([
        'migration' => '2025_09_05_195517_create_leaves_table',
        'batch' => DB::table('migrations')->max('batch') + 1
    ]);
    echo "Migración '2025_09_05_195517_create_leaves_table' registrada correctamente.\n";
} else {
    echo "La migración '2025_09_05_195517_create_leaves_table' ya está registrada.\n";
}
