<?php

/**
 * هذا الملف يقوم بتحديث نموذج العميل للتأكد من أن جميع العمليات تستخدم معرف العميل (ID) بدلاً من رقم العميل
 */

require_once __DIR__ . '/vendor/autoload.php';

use Illuminate\Support\Facades\Log;

// تهيئة Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

echo "بدء تحديث نموذج العميل...\n";

// مسار ملف نموذج العميل
$modelPath = __DIR__ . '/app/Models/Customer.php';

// قراءة محتوى الملف الحالي
$currentContent = file_get_contents($modelPath);

// إنشاء نسخة احتياطية من الملف الأصلي
$backupPath = $modelPath . '.backup.' . date('Y-m-d-H-i-s');
file_put_contents($backupPath, $currentContent);
echo "تم إنشاء نسخة احتياطية من نموذج العميل في: " . $backupPath . "\n";

// إضافة دالة للحصول على كشوفات حساب العميل باستخدام معرف العميل (ID)
$newMethod = '
    /**
     * الحصول على كشوفات حساب العميل
     * 
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function statements()
    {
        return $this->hasMany(CustomerStatement::class, \'customer_id\', \'id\');
    }

    /**
     * الحصول على الفواتير المرتبطة بالعميل
     * 
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function invoices()
    {
        return $this->hasMany(Invoice::class, \'customer_id\', \'id\');
    }

    /**
     * الحصول على المدفوعات المرتبطة بالعميل
     * 
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function payments()
    {
        return $this->hasMany(Payment::class, \'customer_id\', \'id\');
    }

    /**
     * الحصول على القيود المحاسبية المرتبطة بالعميل
     * 
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function journalEntries()
    {
        return CustomerStatement::where(\'customer_id\', $this->id)
            ->where(\'reference_type\', \'App\\\\Models\\\\JournalEntry\')
            ->with(\'reference\')
            ->get()
            ->pluck(\'reference\')
            ->unique(\'id\');
    }
';

// إضافة الدوال الجديدة إلى نموذج العميل
if (strpos($currentContent, 'public function statements()') === false) {
    // البحث عن نهاية الفئة
    $endOfClass = strrpos($currentContent, '}');

    // إضافة الدوال الجديدة قبل نهاية الفئة
    $newContent = substr($currentContent, 0, $endOfClass) . $newMethod . "\n" . substr($currentContent, $endOfClass);

    // حفظ المحتوى المعدل
    file_put_contents($modelPath, $newContent);
    echo "تم تحديث نموذج العميل بإضافة دوال جديدة للحصول على كشوفات الحساب والفواتير والمدفوعات والقيود المحاسبية.\n";
} else {
    echo "الدوال موجودة بالفعل في نموذج العميل.\n";
}

// تحديث نموذج كشف حساب العميل لإضافة علاقة مع العميل
$statementModelPath = __DIR__ . '/app/Models/CustomerStatement.php';
$statementContent = file_get_contents($statementModelPath);

// إنشاء نسخة احتياطية من ملف نموذج كشف حساب العميل
$statementBackupPath = $statementModelPath . '.backup.' . date('Y-m-d-H-i-s');
file_put_contents($statementBackupPath, $statementContent);
echo "تم إنشاء نسخة احتياطية من نموذج كشف حساب العميل في: " . $statementBackupPath . "\n";

// إضافة دالة للحصول على العميل المرتبط بكشف الحساب
$newStatementMethod = '
    /**
     * الحصول على العميل المرتبط بكشف الحساب
     * 
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function customer()
    {
        return $this->belongsTo(Customer::class, \'customer_id\', \'id\');
    }

    /**
     * الحصول على المرجع المرتبط بكشف الحساب (فاتورة، دفعة، قيد محاسبي)
     * 
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function reference()
    {
        return $this->morphTo();
    }
';

// إضافة الدوال الجديدة إلى نموذج كشف حساب العميل
if (strpos($statementContent, 'public function customer()') === false) {
    // البحث عن نهاية الفئة
    $endOfStatementClass = strrpos($statementContent, '}');

    // إضافة الدوال الجديدة قبل نهاية الفئة
    $newStatementContent = substr($statementContent, 0, $endOfStatementClass) . $newStatementMethod . "\n" . substr($statementContent, $endOfStatementClass);

    // حفظ المحتوى المعدل
    file_put_contents($statementModelPath, $newStatementContent);
    echo "تم تحديث نموذج كشف حساب العميل بإضافة دوال جديدة للحصول على العميل والمرجع.\n";
} else {
    echo "الدوال موجودة بالفعل في نموذج كشف حساب العميل.\n";
}

echo "\nتم الانتهاء من تحديث النماذج. يمكنك الآن استخدام معرف العميل (ID) بدلاً من رقم العميل في جميع العمليات.\n";
echo "لتطبيق التغييرات على القيود المحاسبية الموجودة، قم بتشغيل الملف fix_journal_entries_customer_id.php\n";
