<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;

echo "تحديث أرصدة الحسابات...\n";

// الحصول على جميع الحسابات
$accounts = ChartOfAccount::all();
$updatedCount = 0;

foreach ($accounts as $account) {
    // حفظ الرصيد القديم للمقارنة
    $oldBalance = $account->current_balance;

    // تحديث الرصيد
    $account->updateBalance();

    // إذا تغير الرصيد، نعرض تفاصيل التغيير
    if (abs($oldBalance - $account->current_balance) > 0.01) {
        $updatedCount++;
        echo "تم تحديث حساب: " . $account->name . " (رمز: " . $account->account_code . ")\n";
        echo "الرصيد القديم: " . $oldBalance . "\n";
        echo "الرصيد الجديد: " . $account->current_balance . "\n";
        echo "الفرق: " . abs($oldBalance - $account->current_balance) . "\n";
        echo "-----------------------------------\n";
    }
}

echo "تم تحديث " . $updatedCount . " حساب.\n";
echo "تم الانتهاء من تحديث الأرصدة.\n";
