<?php

require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\CashTransaction;
use App\Http\Controllers\CashTransactionController;

// Obtener la transacción con ID 8
$transaction = CashTransaction::find(8);

if (!$transaction) {
    echo "No se encontró la transacción con ID 8\n";
    exit;
}

// Crear una instancia del controlador
$controller = new CashTransactionController();

// Intentar crear el asiento contable
try {
    $result = $controller->createJournalEntryForWithdrawal($transaction);

    if ($result) {
        echo "¡Éxito! Se ha creado el asiento contable con ID: " . $result->id . "\n";

        // Mostrar detalles del asiento
        echo "Detalles del asiento:\n";
        echo "- Número: " . $result->entry_number . "\n";
        echo "- Fecha: " . $result->entry_date . "\n";
        echo "- Descripción: " . $result->description . "\n";

        // Mostrar los elementos del asiento
        echo "\nElementos del asiento:\n";
        foreach ($result->items as $item) {
            $account = \App\Models\ChartOfAccount::find($item->account_id);
            echo "- Cuenta: " . $account->name . " (" . $account->account_code . ")\n";
            echo "  Debe: " . $item->debit . ", Haber: " . $item->credit . "\n";
            echo "  Descripción: " . $item->description . "\n\n";
        }
    } else {
        echo "Error: No se pudo crear el asiento contable\n";
    }
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Archivo: " . $e->getFile() . " en la línea " . $e->getLine() . "\n";
}
