<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';

$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\Elevator;

try {
    $count = Elevator::count();
    echo "Elevator count: " . $count . PHP_EOL;

    $elevators = Elevator::all();
    echo "Elevators: " . $elevators->count() . PHP_EOL;

    foreach ($elevators as $elevator) {
        echo "ID: " . $elevator->id . ", Serial: " . $elevator->serial_number . PHP_EOL;
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . PHP_EOL;
}
