<?php
require __DIR__ . '/vendor/autoload.php';
require __DIR__ . '/bootstrap/app.php';

$app = new Illuminate\Foundation\Application(
    realpath(__DIR__)
);

$app->singleton(
    Illuminate\Contracts\Http\Kernel::class,
    App\Http\Kernel::class
);

$app->singleton(
    Illuminate\Contracts\Console\Kernel::class,
    App\Console\Kernel::class
);

$app->singleton(
    Illuminate\Contracts\Debug\ExceptionHandler::class,
    App\Exceptions\Handler::class
);

$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// إنشاء خدمة الفواتير
$invoiceService = new App\Services\InvoiceService();

// تحديد معرف العميل وفترة التقرير
$customerId = 9; // العميل رقم 9
$startDate = '2025-01-01';
$endDate = '2025-12-31';

// إنشاء كشف حساب العميل
$statement = $invoiceService->generateCustomerStatement($customerId, $startDate, $endDate);

// عرض معلومات العميل
echo "معلومات العميل:\n";
echo "الاسم: " . $statement['customer']['name'] . "\n";
echo "الفترة: من " . $statement['period']['start_date'] . " إلى " . $statement['period']['end_date'] . "\n";
echo "الرصيد الافتتاحي: " . $statement['opening_balance'] . "\n";
echo "الرصيد الختامي: " . $statement['closing_balance'] . "\n\n";

// عرض ملخص الحساب
echo "ملخص الحساب:\n";
echo "إجمالي الفواتير: " . $statement['summary']['total_invoiced'] . "\n";
echo "إجمالي المدفوعات: " . $statement['summary']['total_paid'] . "\n";
echo "الرصيد المستحق: " . $statement['summary']['balance_due'] . "\n\n";

// عرض المعاملات
echo "المعاملات:\n";
echo str_pad("التاريخ", 12) . " | " .
    str_pad("النوع", 15) . " | " .
    str_pad("الوصف", 50) . " | " .
    str_pad("المرجع", 15) . " | " .
    str_pad("مدين", 12) . " | " .
    str_pad("دائن", 12) . " | " .
    str_pad("الرصيد", 12) . "\n";
echo str_repeat("-", 130) . "\n";

foreach ($statement['transactions'] as $transaction) {
    echo str_pad($transaction['date'], 12) . " | " .
        str_pad($transaction['type'], 15) . " | " .
        str_pad(substr($transaction['description'], 0, 47) . "...", 50) . " | " .
        str_pad($transaction['reference'], 15) . " | " .
        str_pad(number_format($transaction['debit'], 2), 12) . " | " .
        str_pad(number_format($transaction['credit'], 2), 12) . " | " .
        str_pad(number_format($transaction['balance'], 2), 12) . "\n";
}
