<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';

$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\MaintenanceContract;

try {
    $count = MaintenanceContract::count();
    echo "Maintenance Contract count: " . $count . PHP_EOL;

    $contracts = MaintenanceContract::all();
    echo "Contracts: " . $contracts->count() . PHP_EOL;

    foreach ($contracts as $contract) {
        echo "ID: " . $contract->id . ", Number: " . $contract->contract_number . ", Title: " . $contract->title . PHP_EOL;
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . PHP_EOL;
}
