<?php

require_once __DIR__ . '/vendor/autoload.php';

use App\Models\Bank;
use App\Models\ChartOfAccount;
use App\Services\BankAccountService;
use Illuminate\Support\Facades\DB;

// تهيئة Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

echo "اختبار إنشاء حساب بنك تحت الأصول المتداولة...\n";

// إنشاء بنك اختباري
$testBankName = "بنك اختباري " . rand(1000, 9999);
$companyId = 3; // استخدم معرف الشركة المناسب

$bank = new Bank();
$bank->name = $testBankName;
$bank->company_id = $companyId;
$bank->is_active = true;
$bank->save();

echo "تم إنشاء بنك اختباري: {$testBankName} (ID: {$bank->id})\n";

// إنشاء حساب للبنك
$bankAccountService = new BankAccountService();
$bankAccount = $bankAccountService->createBankAccount($bank);

if ($bankAccount) {
    echo "تم إنشاء حساب البنك بنجاح!\n";
    echo "معرف الحساب: {$bankAccount->id}\n";
    echo "رمز الحساب: {$bankAccount->account_code}\n";
    echo "اسم الحساب: {$bankAccount->name}\n";
    echo "معرف الحساب الأب: {$bankAccount->parent_id}\n\n";

    // الحصول على معلومات الحساب الأب
    $parentAccount = ChartOfAccount::find($bankAccount->parent_id);
    echo "تفاصيل الحساب الأب:\n";
    echo "معرف الأب: {$parentAccount->id}\n";
    echo "رمز الأب: {$parentAccount->account_code}\n";
    echo "اسم الأب: {$parentAccount->name}\n";

    // الحصول على معلومات حساب الأصول المتداولة
    $currentAssetsAccount = ChartOfAccount::find($parentAccount->parent_id);
    echo "\nتفاصيل حساب الأصول المتداولة:\n";
    echo "معرف: {$currentAssetsAccount->id}\n";
    echo "رمز: {$currentAssetsAccount->account_code}\n";
    echo "اسم: {$currentAssetsAccount->name}\n";

    // التحقق من أن الحساب الأب هو حساب البنوك وأنه تحت الأصول المتداولة
    if ($parentAccount->account_code === 'BANK' && $currentAssetsAccount->account_code === '1100') {
        echo "\nنجاح! حساب البنك تحت حساب البنوك الذي هو تحت حساب الأصول المتداولة.\n";
    } else {
        echo "\nخطأ! هيكل الحسابات غير صحيح.\n";
    }
} else {
    echo "فشل في إنشاء حساب البنك!\n";
}

echo "\nتم الانتهاء من الاختبار!\n";
