<?php
require_once __DIR__ . '/vendor/autoload.php';

// Initialize Laravel application
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\Bank;
use App\Models\ChartOfAccount;
use App\Services\BankAccountService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

try {
    echo "Testing the fixed BankAccountService...\n\n";

    // Create a test bank
    $testBank = new Bank([
        'company_id' => 3, // Using company ID 3 as in the previous examples
        'name' => 'Test Bank ' . rand(1000, 9999),
        'code' => 'TB' . rand(100, 999),
        'is_active' => true
    ]);

    // Save the bank to the database
    $testBank->save();

    echo "Created test bank: {$testBank->name} (ID: {$testBank->id})\n";

    // Create a bank account service instance
    $bankAccountService = new BankAccountService();

    // Create a bank account
    $account = $bankAccountService->createBankAccount($testBank);

    if ($account) {
        echo "Successfully created bank account!\n";
        echo "Account ID: {$account->id}\n";
        echo "Account Code: {$account->account_code}\n";
        echo "Account Name: {$account->name}\n";
        echo "Parent ID: {$account->parent_id}\n";

        // Get the parent account
        $parentAccount = ChartOfAccount::find($account->parent_id);
        echo "\nParent Account Details:\n";
        echo "Parent ID: {$parentAccount->id}\n";
        echo "Parent Code: {$parentAccount->account_code}\n";
        echo "Parent Name: {$parentAccount->name}\n";

        // Check if the parent account is the BANK account
        if ($parentAccount->account_code === 'BANK') {
            echo "\nSuccess! The parent account is the BANK account.\n";
        } else {
            echo "\nWarning: The parent account is not the BANK account.\n";
        }
    } else {
        echo "Failed to create bank account.\n";
    }

    echo "\nTest completed successfully!\n";
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}
