<?php

/**
 * سكريبت لاختبار إنشاء حساب بنكي جديد
 */

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';

use App\Models\Bank;
use App\Models\ChartOfAccount;
use App\Services\BankAccountService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

// تهيئة التطبيق
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "بدء اختبار إنشاء حساب بنكي جديد...\n\n";

// إنشاء بنك اختباري جديد
$testBankName = 'بنك اختباري ' . rand(1000, 9999);
$companyId = 3; // الشركة رقم 3

echo "إنشاء بنك اختباري جديد: {$testBankName} للشركة {$companyId}\n";

$bank = new Bank();
$bank->name = $testBankName;
$bank->company_id = $companyId;
$bank->swift_code = 'TEST' . rand(1000, 9999);
$bank->is_active = true;

try {
    $bank->save();
    echo "تم إنشاء البنك بنجاح: ID: {$bank->id}\n";
} catch (\Exception $e) {
    echo "فشل في إنشاء البنك: " . $e->getMessage() . "\n";
    exit;
}

// إنشاء حساب بنكي للبنك الجديد
echo "\nإنشاء حساب بنكي للبنك الجديد...\n";

$bankAccountService = new BankAccountService();

try {
    $account = $bankAccountService->createBankAccount($bank);

    if ($account) {
        echo "تم إنشاء حساب البنك بنجاح:\n";
        echo "- ID: {$account->id}\n";
        echo "- الاسم: {$account->name}\n";
        echo "- الرمز: {$account->account_code}\n";
        echo "- المستوى: {$account->level}\n";
        echo "- الحساب الأب: {$account->parent_id}\n";
    } else {
        echo "فشل في إنشاء حساب البنك.\n";
    }
} catch (\Exception $e) {
    echo "حدث خطأ أثناء إنشاء حساب البنك: " . $e->getMessage() . "\n";
}

// التحقق من حساب البنك الرئيسي
echo "\nالتحقق من حساب البنك الرئيسي للشركة {$companyId}:\n";

$parentBankAccount = ChartOfAccount::where('company_id', $companyId)
    ->where('account_code', 'BANK')
    ->first();

if ($parentBankAccount) {
    echo "- ID: {$parentBankAccount->id}\n";
    echo "- الاسم: {$parentBankAccount->name}\n";
    echo "- المستوى: {$parentBankAccount->level}\n";
    echo "- الحساب الأب: {$parentBankAccount->parent_id}\n";

    // التحقق من الحساب الأب (الأصول المتداولة)
    $currentAssetsAccount = ChartOfAccount::find($parentBankAccount->parent_id);
    if ($currentAssetsAccount) {
        echo "- الحساب الأب: {$currentAssetsAccount->name} (ID: {$currentAssetsAccount->id}, الرمز: {$currentAssetsAccount->account_code})\n";
    }

    // عرض عدد الحسابات البنكية الفردية تحت حساب البنك الرئيسي
    $childAccounts = ChartOfAccount::where('parent_id', $parentBankAccount->id)
        ->where('is_bank_account', true)
        ->get();

    echo "- عدد الحسابات البنكية الفردية: " . $childAccounts->count() . "\n";
} else {
    echo "لا يوجد حساب بنك رئيسي للشركة {$companyId}.\n";
}

echo "\nتم الانتهاء من اختبار إنشاء حساب بنكي جديد.\n";
