

<?php $__env->startSection('title', $customer->name); ?>

<?php $__env->startSection('header', $customer->name); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">Customer Information</h6>
                <div>
                    <?php if(auth()->user()->can('edit customers') || auth()->user()->id == $customer->user_id): ?>
                    <a href="<?php echo e(route('customers.edit', $customer->id)); ?>" class="btn btn-primary btn-sm">
                        <i class="bi bi-pencil"></i> Edit
                    </a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <h5 class="font-weight-bold"><?php echo e($customer->name); ?></h5>
                    <p class="mb-1">
                        <span class="badge bg-<?php echo e($customer->status == 'active' ? 'success' : ($customer->status == 'inactive' ? 'danger' : ($customer->status == 'lead' ? 'warning' : 'info'))); ?>">
                            <?php echo e(ucfirst($customer->status)); ?>

                        </span>
                        <span class="badge bg-secondary"><?php echo e(ucfirst($customer->type)); ?></span>
                    </p>
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">Contact Information</h6>
                    <?php if($customer->email): ?>
                        <p class="mb-1"><i class="bi bi-envelope me-2"></i> <?php echo e($customer->email); ?></p>
                    <?php endif; ?>
                    <?php if($customer->phone): ?>
                        <p class="mb-1"><i class="bi bi-telephone me-2"></i> <?php echo e($customer->phone); ?></p>
                    <?php endif; ?>
                    <?php if($customer->tax_number): ?>
                        <p class="mb-1"><i class="bi bi-card-list me-2"></i> Tax Number: <?php echo e($customer->tax_number); ?></p>
                    <?php endif; ?>
                </div>
                
                <?php if($customer->contact_person): ?>
                <div class="mb-3">
                    <h6 class="font-weight-bold">Contact Person</h6>
                    <p class="mb-1"><strong>Name:</strong> <?php echo e($customer->contact_person); ?></p>
                    <?php if($customer->contact_position): ?>
                        <p class="mb-1"><strong>Position:</strong> <?php echo e($customer->contact_position); ?></p>
                    <?php endif; ?>
                    <?php if($customer->contact_phone): ?>
                        <p class="mb-1"><strong>Phone:</strong> <?php echo e($customer->contact_phone); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <?php if($customer->address || $customer->city || $customer->state || $customer->country): ?>
                <div class="mb-3">
                    <h6 class="font-weight-bold">Address</h6>
                    <?php if($customer->address): ?>
                        <p class="mb-1"><?php echo e($customer->address); ?></p>
                    <?php endif; ?>
                    <p class="mb-1">
                        <?php if($customer->city): ?><?php echo e($customer->city); ?><?php endif; ?>
                        <?php if($customer->state): ?><?php echo e($customer->city ? ', ' : ''); ?><?php echo e($customer->state); ?><?php endif; ?>
                        <?php if($customer->postal_code): ?><?php echo e(($customer->city || $customer->state) ? ' ' : ''); ?><?php echo e($customer->postal_code); ?><?php endif; ?>
                    </p>
                    <?php if($customer->country): ?>
                        <p class="mb-1"><?php echo e($customer->country); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">Company & Branch</h6>
                    <p class="mb-1"><strong>Company:</strong> 
                        <?php if($customer->company): ?>
                            <a href="<?php echo e(route('companies.show', $customer->company_id)); ?>"><?php echo e($customer->company->name); ?></a>
                        <?php else: ?>
                            <span class="text-muted">Not assigned</span>
                        <?php endif; ?>
                    </p>
                    <p class="mb-1"><strong>Branch:</strong> 
                        <?php if($customer->branch_id && isset($customer->branch) && $customer->branch): ?>
                            <a href="<?php echo e(route('branches.show', $customer->branch_id)); ?>"><?php echo e($customer->branch->name); ?></a>
                        <?php else: ?>
                            <span class="text-muted">Not assigned</span>
                        <?php endif; ?>
                    </p>
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">Account Information</h6>
                    <p class="mb-1"><strong>Assigned To:</strong> 
                        <?php if($customer->user_id && isset($customer->user) && $customer->user): ?>
                            <a href="<?php echo e(route('users.show', $customer->user_id)); ?>"><?php echo e($customer->user->name); ?></a>
                        <?php else: ?>
                            <span class="text-muted">Not assigned</span>
                        <?php endif; ?>
                    </p>
                    <p class="mb-1"><strong>Created:</strong> <?php echo e($customer->created_at->format('M d, Y')); ?></p>
                    <p class="mb-1"><strong>Last Updated:</strong> <?php echo e($customer->updated_at->format('M d, Y')); ?></p>
                </div>
                
                <?php if($customer->notes): ?>
                <div class="mb-3">
                    <h6 class="font-weight-bold">Notes</h6>
                    <p class="mb-1"><?php echo e($customer->notes); ?></p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="col-md-8 mb-4">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Customer Overview</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-info shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            Elevators</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($statistics['elevators_count']); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-arrow-up-square fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-success shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            Locations</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($statistics['locations_count']); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-geo-alt fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-warning shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                            Contracts</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($statistics['contracts_count']); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-file-earmark-text fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                            Invoices</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($statistics['invoices_count']); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-receipt fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4 mb-4">
                        <div class="card border-left-primary shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            Total Invoiced</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(number_format($statistics['total_invoiced'], 2)); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-cash-stack fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-4">
                        <div class="card border-left-success shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            Total Paid</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(number_format($statistics['total_paid'], 2)); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-check-circle fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-4">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                            Total Due</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(number_format($statistics['total_due'], 2)); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-exclamation-circle fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="d-flex justify-content-between">
                            <a href="<?php echo e(route('locations.index', ['customer_id' => $customer->id])); ?>" class="btn btn-success">
                                <i class="bi bi-geo-alt"></i> View Locations
                            </a>
                            <a href="<?php echo e(route('elevators.index', ['customer_id' => $customer->id])); ?>" class="btn btn-info">
                                <i class="bi bi-arrow-up-square"></i> View Elevators
                            </a>
                            <a href="<?php echo e(route('maintenance-contracts.index', ['customer_id' => $customer->id])); ?>" class="btn btn-warning">
                                <i class="bi bi-file-earmark-text"></i> View Contracts
                            </a>
                            <a href="<?php echo e(route('invoices.index', ['customer_id' => $customer->id])); ?>" class="btn btn-danger">
                                <i class="bi bi-receipt"></i> View Invoices
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">Recent Elevators</h6>
                <a href="<?php echo e(route('elevators.index', ['customer_id' => $customer->id])); ?>" class="btn btn-sm btn-primary">View All</a>
            </div>
            <div class="card-body">
                <?php if($customer->elevators()->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Serial Number</th>
                                <th>Model</th>
                                <th>Location</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $customer->elevators()->latest()->take(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $elevator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($elevator->serial_number); ?></td>
                                <td><?php echo e($elevator->model); ?></td>
                                <td><?php echo e($elevator->location ? $elevator->location->name : 'N/A'); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($elevator->status == 'operational' ? 'success' : ($elevator->status == 'maintenance' ? 'warning' : 'danger')); ?>">
                                        <?php echo e(ucfirst($elevator->status)); ?>

                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('elevators.show', $elevator->id)); ?>" class="btn btn-info btn-sm">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <div class="text-center py-3">
                    <p>No elevators found for this customer.</p>
                    <a href="<?php echo e(route('elevators.create', ['customer_id' => $customer->id])); ?>" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Add Elevator
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.modern', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp8-2-new\htdocs\elevators_erp-m\resources\views/customers/show.blade.php ENDPATH**/ ?>