<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>نظام إدارة المصاعد - حلول متكاملة لشركات المصاعد</title>
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700&display=swap" rel="stylesheet">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom Styles -->
    <style>
        :root {
            --primary-color: #FFD700; /* ذهبي */
            --secondary-color: #B8860B; /* ذهبي داكن */
            --accent-color: #DAA520; /* ذهبي متوسط */
            --light-color: #FFFACD; /* أصفر فاتح */
            --dark-color: #8B4513; /* بني داكن */
            --text-color: #4A3500; /* لون النص الداكن */
        }
        
        body {
            font-family: 'Tajawal', sans-serif;
            color: var(--text-color);
            overflow-x: hidden;
            direction: rtl;
            text-align: right;
        }
        
        .bg-gradient {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
        }
        
        .text-primary-custom {
            color: var(--primary-color);
        }
        
        .btn-primary-custom {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            color: var(--dark-color);
            padding: 10px 25px;
            border-radius: 30px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .btn-primary-custom:hover {
            background-color: var(--accent-color);
            border-color: var(--accent-color);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .btn-secondary-custom {
            background-color: var(--secondary-color);
            border-color: var(--secondary-color);
            color: white;
            padding: 10px 25px;
            border-radius: 30px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .btn-secondary-custom:hover {
            background-color: var(--dark-color);
            border-color: var(--dark-color);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .navbar {
            padding: 15px 0;
            transition: all 0.3s ease;
        }
        
        .navbar-scrolled {
            background-color: white;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            padding: 10px 0;
        }
        
        .hero-section {
            min-height: 100vh;
            display: flex;
            align-items: center;
            position: relative;
            overflow: hidden;
            background: linear-gradient(rgba(184, 134, 11, 0.8), rgba(139, 69, 19, 0.8)), url('https://images.unsplash.com/photo-1626250788938-d423e85adb25?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1920&q=80');
            background-size: cover;
            background-position: center;
            color: white;
        }
        
        .feature-card {
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
            height: 100%;
            border: 1px solid #eee;
        }
        
        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            border-color: var(--primary-color);
        }
        
        .feature-icon {
            width: 70px;
            height: 70px;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: rgba(255, 215, 0, 0.2);
            color: var(--secondary-color);
            border-radius: 50%;
            margin-bottom: 20px;
            font-size: 28px;
        }
        
        .testimonial-card {
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
            margin: 20px 10px;
            position: relative;
        }
        
        .testimonial-card::before {
            content: '"';
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 60px;
            color: rgba(255, 215, 0, 0.2);
            font-family: Georgia, serif;
        }
        
        .cta-section {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: var(--dark-color);
            padding: 80px 0;
            border-radius: 10px;
            margin: 50px 0;
        }
        
        .footer {
            background-color: var(--dark-color);
            color: white;
            padding: 60px 0 30px;
        }
        
        .footer-links h5 {
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        .footer-links ul {
            list-style: none;
            padding-right: 0;
        }
        
        .footer-links ul li {
            margin-bottom: 10px;
        }
        
        .footer-links ul li a {
            color: rgba(255, 255, 255, 0.7);
            text-decoration: none;
            transition: all 0.3s ease;
        }
        
        .footer-links ul li a:hover {
            color: var(--primary-color);
            padding-right: 5px;
        }
        
        .social-icons a {
            display: inline-block;
            width: 40px;
            height: 40px;
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            text-align: center;
            line-height: 40px;
            color: white;
            margin-left: 10px;
            transition: all 0.3s ease;
        }
        
        .social-icons a:hover {
            background-color: var(--primary-color);
            color: var(--dark-color);
            transform: translateY(-3px);
        }
        
        .copyright {
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            padding-top: 20px;
            margin-top: 40px;
        }
        
        @media (max-width: 768px) {
            .hero-section {
                text-align: center;
            }
            
            .hero-section img {
                margin-top: 30px;
            }
        }
        
        /* Animation */
        .fade-in {
            animation: fadeIn 1s ease-in-out;
        }
        
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .floating {
            animation: floating 3s ease-in-out infinite;
        }
        
        @keyframes floating {
            0% {
                transform: translateY(0px);
            }
            50% {
                transform: translateY(-15px);
            }
            100% {
                transform: translateY(0px);
            }
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light fixed-top">
        <div class="container">
            <a class="navbar-brand fw-bold" href="#">
                <span class="text-primary-custom">المصاعد</span> نظام إدارة
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="#features">المميزات</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#benefits">الفوائد</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#modules">الوحدات</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#contact">اتصل بنا</a>
                    </li>
                    <?php if(Route::has('login')): ?>
                        <?php if(auth()->guard()->check()): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(url('/dashboard')); ?>" class="nav-link">لوحة التحكم</a>
                            </li>
                        <?php else: ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('login')); ?>" class="nav-link">تسجيل الدخول</a>
                            </li>
                            <?php if(Route::has('register')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('register')); ?>" class="btn btn-primary-custom me-3">إنشاء حساب</a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 fade-in">
                    <h1 class="display-4 fw-bold mb-4">ارتقِ بإدارة شركة المصاعد الخاصة بك</h1>
                    <p class="lead mb-4">نظام إدارة متكامل مصمم خصيصًا لشركات صيانة وإدارة المصاعد. تبسيط العمليات، تحسين جودة الخدمة، وزيادة الربحية.</p>
                    <div class="d-flex flex-wrap gap-2">
                        <a href="#features" class="btn btn-primary-custom">استكشف المميزات</a>
                        <?php if(Route::has('register')): ?>
                            <a href="<?php echo e(route('register')); ?>" class="btn btn-secondary-custom me-2">ابدأ الآن</a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-6">
                    <img src="https://cdn-icons-png.flaticon.com/512/2313/2313906.png" alt="إدارة المصاعد" class="img-fluid floating" style="max-height: 400px; filter: brightness(0) invert(1);">
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-5 my-5" id="features">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold">مميزات قوية</h2>
                <p class="lead text-muted">كل ما تحتاجه لإدارة أعمال المصاعد الخاصة بك بكفاءة</p>
            </div>
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-building"></i>
                        </div>
                        <h4>إدارة الشركات</h4>
                        <p>إدارة شركات متعددة وفروع وأقسام بسهولة. تتبع مؤشرات الأداء وإنشاء التقارير.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <h4>إدارة المستخدمين والأدوار</h4>
                        <p>إنشاء أدوار مخصصة بصلاحيات محددة. التحكم في الوصول إلى المعلومات والعمليات الحساسة.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-user-tie"></i>
                        </div>
                        <h4>إدارة العملاء</h4>
                        <p>الاحتفاظ بملفات تعريف مفصلة للعملاء، وتتبع التفاعلات، وإدارة العلاقات بفعالية.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-elevator"></i>
                        </div>
                        <h4>إدارة المصاعد</h4>
                        <p>تتبع جميع تفاصيل المصاعد بما في ذلك المواصفات وتاريخ الصيانة وحالة الامتثال.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-file-contract"></i>
                        </div>
                        <h4>عقود الصيانة</h4>
                        <p>إنشاء وإدارة اتفاقيات الخدمة، وجدولة زيارات الصيانة، وتتبع تجديدات العقود.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-file-invoice-dollar"></i>
                        </div>
                        <h4>الفواتير والمحاسبة</h4>
                        <p>إنشاء الفواتير، وتتبع المدفوعات، وإدارة المعاملات المالية مع تقارير شاملة.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Benefits Section -->
    <section class="py-5 bg-light" id="benefits">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold">لماذا تختار نظام إدارة المصاعد؟</h2>
                <p class="lead text-muted">فوائد تحول عمليات أعمالك</p>
            </div>
            <div class="row align-items-center">
                <div class="col-lg-6 order-lg-2 mb-4 mb-lg-0">
                    <img src="https://cdn-icons-png.flaticon.com/512/2313/2313966.png" alt="الفوائد" class="img-fluid rounded" style="max-height: 400px;">
                </div>
                <div class="col-lg-6 order-lg-1">
                    <div class="d-flex mb-4">
                        <div class="ms-3 text-primary-custom">
                            <i class="fas fa-check-circle fa-2x"></i>
                        </div>
                        <div>
                            <h4>زيادة الكفاءة</h4>
                            <p>أتمتة المهام الروتينية وتبسيط سير العمل لتوفير الوقت وتقليل تكاليف التشغيل.</p>
                        </div>
                    </div>
                    <div class="d-flex mb-4">
                        <div class="ms-3 text-primary-custom">
                            <i class="fas fa-check-circle fa-2x"></i>
                        </div>
                        <div>
                            <h4>تحسين جودة الخدمة</h4>
                            <p>تحسين جدولة الصيانة، وتقليل وقت التوقف، وتقديم خدمة أفضل لعملائك.</p>
                        </div>
                    </div>
                    <div class="d-flex mb-4">
                        <div class="ms-3 text-primary-custom">
                            <i class="fas fa-check-circle fa-2x"></i>
                        </div>
                        <div>
                            <h4>قرارات مبنية على البيانات</h4>
                            <p>الوصول إلى التحليلات في الوقت الفعلي والتقارير الشاملة لاتخاذ قرارات عمل مستنيرة.</p>
                        </div>
                    </div>
                    <div class="d-flex">
                        <div class="ms-3 text-primary-custom">
                            <i class="fas fa-check-circle fa-2x"></i>
                        </div>
                        <div>
                            <h4>آمن وموثوق</h4>
                            <p>مبني بميزات أمان متقدمة لحماية بيانات عملك الحساسة.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Modules Section -->
    <section class="py-5 my-5" id="modules">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold">وحدات شاملة</h2>
                <p class="lead text-muted">حل متكامل لجميع احتياجات إدارة المصاعد الخاصة بك</p>
            </div>
            <div class="row g-4">
                <div class="col-md-6 col-lg-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-primary-custom rounded-circle p-2 ms-3" style="width: 45px; height: 45px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-building text-dark"></i>
                                </div>
                                <h5 class="card-title mb-0">إدارة الشركات</h5>
                            </div>
                            <ul class="list-unstyled">
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> ملفات تعريف شركات متعددة</li>
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> إدارة المكاتب الفرعية</li>
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> تنظيم الأقسام</li>
                                <li><i class="fas fa-check text-primary-custom ms-2"></i> التقارير المالية</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-primary-custom rounded-circle p-2 ms-3" style="width: 45px; height: 45px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-shield-alt text-dark"></i>
                                </div>
                                <h5 class="card-title mb-0">الأمان والوصول</h5>
                            </div>
                            <ul class="list-unstyled">
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> التحكم في الوصول القائم على الأدوار</li>
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> أذونات مخصصة</li>
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> المصادقة الثنائية</li>
                                <li><i class="fas fa-check text-primary-custom ms-2"></i> تسجيل النشاط</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-primary-custom rounded-circle p-2 ms-3" style="width: 45px; height: 45px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-user-tie text-dark"></i>
                                </div>
                                <h5 class="card-title mb-0">إدارة العملاء</h5>
                            </div>
                            <ul class="list-unstyled">
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> ملفات تعريف العملاء</li>
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> إدارة جهات الاتصال</li>
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> سجل الخدمة</li>
                                <li><i class="fas fa-check text-primary-custom ms-2"></i> سجلات الاتصال</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-primary-custom rounded-circle p-2 ms-3" style="width: 45px; height: 45px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-elevator text-dark"></i>
                                </div>
                                <h5 class="card-title mb-0">إدارة المصاعد</h5>
                            </div>
                            <ul class="list-unstyled">
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> جرد المعدات</li>
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> سجل الصيانة</li>
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> تتبع الامتثال</li>
                                <li><i class="fas fa-check text-primary-custom ms-2"></i> مراقبة الأداء</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-primary-custom rounded-circle p-2 ms-3" style="width: 45px; height: 45px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-tools text-dark"></i>
                                </div>
                                <h5 class="card-title mb-0">الصيانة</h5>
                            </div>
                            <ul class="list-unstyled">
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> عقود الخدمة</li>
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> الصيانة المجدولة</li>
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> أوامر العمل</li>
                                <li><i class="fas fa-check text-primary-custom ms-2"></i> تقارير الخدمة</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-primary-custom rounded-circle p-2 ms-3" style="width: 45px; height: 45px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-file-invoice-dollar text-dark"></i>
                                </div>
                                <h5 class="card-title mb-0">الفواتير والمالية</h5>
                            </div>
                            <ul class="list-unstyled">
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> إنشاء الفواتير</li>
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> تتبع المدفوعات</li>
                                <li class="mb-2"><i class="fas fa-check text-primary-custom ms-2"></i> التقارير المالية</li>
                                <li><i class="fas fa-check text-primary-custom ms-2"></i> تحليلات الإيرادات</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section" id="contact">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <h2 class="fw-bold mb-4">هل أنت مستعد لتحويل أعمال المصاعد الخاصة بك؟</h2>
                    <p class="lead mb-4">انضم إلى مئات شركات المصاعد التي تستخدم بالفعل نظام إدارة المصاعد لتبسيط العمليات وزيادة الربحية.</p>
                    <div class="d-flex justify-content-center flex-wrap gap-3">
                        <?php if(Route::has('register')): ?>
                            <a href="<?php echo e(route('register')); ?>" class="btn btn-light btn-lg">ابدأ الآن</a>
                        <?php endif; ?>
                        <a href="<?php echo e(route('login')); ?>" class="btn btn-outline-light btn-lg">تسجيل الدخول</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4 mb-lg-0">
                    <h3 class="text-white mb-4">نظام إدارة المصاعد</h3>
                    <p class="text-white-50">نظام تخطيط موارد المؤسسات الشامل المصمم خصيصًا لشركات صيانة وإدارة المصاعد.</p>
                    <div class="social-icons mt-4">
                        <a href="#"><i class="fab fa-facebook-f"></i></a>
                        <a href="#"><i class="fab fa-twitter"></i></a>
                        <a href="#"><i class="fab fa-linkedin-in"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 mb-4 mb-md-0">
                    <div class="footer-links">
                        <h5>الشركة</h5>
                        <ul>
                            <li><a href="#">من نحن</a></li>
                            <li><a href="#">فريقنا</a></li>
                            <li><a href="#">الوظائف</a></li>
                            <li><a href="#">اتصل بنا</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 mb-4 mb-md-0">
                    <div class="footer-links">
                        <h5>المنتج</h5>
                        <ul>
                            <li><a href="#features">المميزات</a></li>
                            <li><a href="#benefits">الفوائد</a></li>
                            <li><a href="#modules">الوحدات</a></li>
                            <li><a href="#">الأسعار</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 mb-4 mb-md-0">
                    <div class="footer-links">
                        <h5>الدعم</h5>
                        <ul>
                            <li><a href="#">مركز المساعدة</a></li>
                            <li><a href="#">التوثيق</a></li>
                            <li><a href="#">واجهة برمجة التطبيقات</a></li>
                            <li><a href="#">الحالة</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4">
                    <div class="footer-links">
                        <h5>قانوني</h5>
                        <ul>
                            <li><a href="#">سياسة الخصوصية</a></li>
                            <li><a href="#">شروط الخدمة</a></li>
                            <li><a href="#">الأمان</a></li>
                            <li><a href="#">الامتثال</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="copyright text-center text-white-50">
                <p>&copy; <?php echo e(date('Y')); ?> نظام إدارة المصاعد. جميع الحقوق محفوظة.</p>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script>
        // Navbar scroll effect
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.classList.add('navbar-scrolled', 'bg-white');
            } else {
                navbar.classList.remove('navbar-scrolled', 'bg-white');
            }
        });
        
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function(e) {
                e.preventDefault();
                
                const targetId = this.getAttribute('href');
                if (targetId === '#') return;
                
                const targetElement = document.querySelector(targetId);
                if (targetElement) {
                    window.scrollTo({
                        top: targetElement.offsetTop - 80,
                        behavior: 'smooth'
                    });
                }
            });
        });
    </script>
</body>
</html><?php /**PATH D:\xampp8-2-new\htdocs\elevators_erp-m\resources\views/welcome.blade.php ENDPATH**/ ?>