<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span><?php echo e(__('قائمة المصاعد')); ?></span>
                    <div>
                        <div class="dropdown d-inline-block me-2">
                            <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fas fa-download"></i> <?php echo e(__('تحميل نموذج الاستيراد')); ?>

                            </button>
                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                <li><a class="dropdown-item" href="<?php echo e(asset('templates/elevators_import_template.csv')); ?>"><?php echo e(__('تحميل نموذج CSV')); ?></a></li>
                                <li><a class="dropdown-item" href="<?php echo e(route('elevators.import.template.excel')); ?>"><?php echo e(__('تحميل نموذج Excel')); ?></a></li>
                            </ul>
                        </div>
                        <a href="<?php echo e(route('elevators.import.form')); ?>" class="btn btn-success btn-sm me-2">
                            <i class="fas fa-file-import"></i> <?php echo e(__('استيراد من Excel')); ?>

                        </a>
                        <a href="<?php echo e(route('elevators.create')); ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> <?php echo e(__('إضافة مصعد جديد')); ?>

                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <?php echo $__env->make('layouts.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <form action="<?php echo e(route('elevators.index')); ?>" method="GET" class="d-flex">
                                <input type="text" name="search" class="form-control me-2" placeholder="<?php echo e(__('بحث بالرقم التسلسلي أو اسم العميل...')); ?>" value="<?php echo e($search ?? ''); ?>">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> <?php echo e(__('بحث')); ?>

                                </button>
                                <?php if(request()->has('search')): ?>
                                    <a href="<?php echo e(route('elevators.index')); ?>" class="btn btn-secondary ms-2">
                                        <i class="fas fa-undo"></i>
                                    </a>
                                <?php endif; ?>
                            </form>
                        </div>
                    </div>

                    <?php if(count($elevators) > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('الرقم التسلسلي')); ?></th>
                                        <th><?php echo e(__('الموديل')); ?></th>
                                        <th><?php echo e(__('الشركة المصنعة')); ?></th>
                                        <th><?php echo e(__('العميل')); ?></th>
                                        <th><?php echo e(__('الموقع')); ?></th>
                                        <th><?php echo e(__('الحالة')); ?></th>
                                        <th><?php echo e(__('تاريخ التركيب')); ?></th>
                                        <th><?php echo e(__('الإجراءات')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $elevators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $elevator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1 + ($elevators->currentPage() - 1) * $elevators->perPage()); ?></td>
                                            <td><?php echo e($elevator->serial_number); ?></td>
                                            <td><?php echo e($elevator->model); ?></td>
                                            <td><?php echo e($elevator->manufacturer); ?></td>
                                            <td><?php echo e($elevator->customer ? $elevator->customer->name : 'غير محدد'); ?></td>
                                            <td><?php echo e($elevator->location ? $elevator->location->name : 'غير محدد'); ?></td>
                                            <td>
                                                <?php if($elevator->status == 'operational'): ?>
                                                    <span class="badge bg-success">يعمل</span>
                                                <?php elseif($elevator->status == 'maintenance'): ?>
                                                    <span class="badge bg-warning">تحت الصيانة</span>
                                                <?php elseif($elevator->status == 'out_of_service'): ?>
                                                    <span class="badge bg-danger">خارج الخدمة</span>
                                                <?php elseif($elevator->status == 'installation'): ?>
                                                    <span class="badge bg-info">قيد التركيب</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($elevator->installation_date ? $elevator->installation_date->format('Y-m-d') : 'غير محدد'); ?></td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="<?php echo e(route('elevators.show', $elevator->id)); ?>" class="btn btn-info btn-sm" title="عرض">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="<?php echo e(route('elevators.edit', $elevator->id)); ?>" class="btn btn-primary btn-sm" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="<?php echo e(route('elevators.destroy', $elevator->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا المصعد؟');">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-danger btn-sm" title="حذف">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="d-flex justify-content-center mt-4">
                            <?php echo e($elevators->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="alert alert-info text-center">
                            <?php echo e(__('لا توجد مصاعد مسجلة حتى الآن')); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.modern', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp8-2-new\htdocs\elevators_erp-m\resources\views/elevators/index.blade.php ENDPATH**/ ?>