<div class="sidebar">
    <nav class="mt-1">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
            <!-- لوحة التحكم -->
            <li class="nav-item">
                <a href="<?php echo e(route('dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-tachometer-alt"></i>
                    <p>لوحة التحكم</p>
                </a>
            </li>

            <!-- نظام الإشعارات -->
            <li class="nav-item <?php echo e(request()->routeIs('notifications.*') || request()->routeIs('notification-settings.*') || request()->routeIs('notification-logs.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('notifications.*') || request()->routeIs('notification-settings.*') || request()->routeIs('notification-logs.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-bell"></i>
                    <p>
                        نظام الإشعارات
                        <span class="badge badge-danger right" id="sidebar-notification-count">0</span>
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('notifications.index')); ?>" class="nav-link <?php echo e(request()->routeIs('notifications.index') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة الإشعارات</p>
                        </a>
                    </li>
                    
                    <?php if(auth()->check() && auth()->user()->hasPermission('view_urgent_notifications')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('notifications.urgent')); ?>" class="nav-link <?php echo e(request()->routeIs('notifications.urgent') ? 'active' : ''); ?>">
                            <i class="fas fa-exclamation-circle nav-icon"></i>
                            <p>الإشعارات العاجلة</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if(auth()->check() && auth()->user()->hasPermission('manage_notification_settings')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('notification-settings.index')); ?>" class="nav-link <?php echo e(request()->routeIs('notification-settings.*') ? 'active' : ''); ?>">
                            <i class="fas fa-cog nav-icon"></i>
                            <p>إعدادات الإشعارات</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if(auth()->check() && auth()->user()->hasPermission('view_notification_logs')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('notification-logs.index')); ?>" class="nav-link <?php echo e(request()->routeIs('notification-logs.*') ? 'active' : ''); ?>">
                            <i class="fas fa-history nav-icon"></i>
                            <p>سجلات الإشعارات</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if(auth()->check() && auth()->user()->hasPermission('run_maintenance_notifications')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('notifications.run-maintenance-check')); ?>" class="nav-link <?php echo e(request()->routeIs('notifications.run-maintenance-check') ? 'active' : ''); ?>">
                            <i class="fas fa-sync nav-icon"></i>
                            <p>تشغيل فحص الصيانة</p>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>

            <!-- إدارة المستخدمين -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('manage_users') || auth()->user()->hasPermission('view_users') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('users.*') || request()->routeIs('roles.*') || request()->routeIs('permissions.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('users.*') || request()->routeIs('roles.*') || request()->routeIs('permissions.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-users-cog"></i>
                    <p>
                        إدارة المستخدمين
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <?php if(auth()->user()->hasPermission('view_users') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('users.index')); ?>" class="nav-link <?php echo e(request()->routeIs('users.index') ? 'active' : ''); ?>">
                            <i class="fas fa-user-friends nav-icon"></i>
                            <p>قائمة المستخدمين</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if(auth()->user()->hasPermission('manage_users') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('users.create')); ?>" class="nav-link <?php echo e(request()->routeIs('users.create') ? 'active' : ''); ?>">
                            <i class="fas fa-user-plus nav-icon"></i>
                            <p>إضافة مستخدم جديد</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if(auth()->user()->hasPermission('view_roles') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('roles.index')); ?>" class="nav-link <?php echo e(request()->routeIs('roles.index') ? 'active' : ''); ?>">
                            <i class="fas fa-user-shield nav-icon"></i>
                            <p>الأدوار والصلاحيات</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if(auth()->user()->hasPermission('manage_roles') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('roles.manage-users')); ?>" class="nav-link <?php echo e(request()->routeIs('roles.manage-users') ? 'active' : ''); ?>">
                            <i class="fas fa-user-cog nav-icon"></i>
                            <p>إدارة أدوار المستخدمين</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('roles.edit-user-roles', ['user' => auth()->id()])); ?>" class="nav-link <?php echo e(request()->routeIs('roles.edit-user-roles') ? 'active' : ''); ?>">
                            <i class="fas fa-user-tag nav-icon"></i>
                            <p>تعديل أدوار المستخدم</p>
                        </a>
                    </li>
                    
                    <?php if(auth()->user()->hasPermission('view_permissions') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('permissions.index')); ?>" class="nav-link <?php echo e(request()->routeIs('permissions.index') && !request()->routeIs('permissions.create') && !request()->routeIs('permissions.edit') && !request()->routeIs('permissions.show') ? 'active' : ''); ?>">
                            <i class="fas fa-key nav-icon"></i>
                            <p>قائمة الصلاحيات</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if(auth()->user()->hasPermission('manage_permissions') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('permissions.create')); ?>" class="nav-link <?php echo e(request()->routeIs('permissions.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة صلاحية جديدة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('permissions.manage-users')); ?>" class="nav-link <?php echo e(request()->routeIs('permissions.manage-users') ? 'active' : ''); ?>">
                            <i class="fas fa-user-lock nav-icon"></i>
                            <p>إدارة صلاحيات المستخدمين</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('permissions.edit-user-permissions', ['user' => auth()->id()])); ?>" class="nav-link <?php echo e(request()->routeIs('permissions.edit-user-permissions') ? 'active' : ''); ?>">
                            <i class="fas fa-user-edit nav-icon"></i>
                            <p>تعديل صلاحيات المستخدم</p>
                        </a>
                    </li>
                    
                    <?php if(auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('permissions.generate-from-controllers')); ?>" class="nav-link <?php echo e(request()->routeIs('permissions.generate-from-controllers') ? 'active' : ''); ?>">
                            <i class="fas fa-sync nav-icon"></i>
                            <p>توليد الصلاحيات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('temp.permissions.manage-users')); ?>" class="nav-link <?php echo e(request()->routeIs('temp.permissions.*') ? 'active' : ''); ?>">
                            <i class="fas fa-key nav-icon"></i>
                            <p>إدارة صلاحيات المستخدمين (مؤقت)</p>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            <!-- إدارة الشركات -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('manage_companies') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9 || auth()->user()->id == 6 || auth()->user()->email == 'manager3@manager3.com')): ?>
            <li class="nav-item <?php echo e(request()->routeIs('company_management.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('company_management.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-building"></i>
                    <p>
                        إدارة الشركات
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('company_management.index')); ?>" class="nav-link <?php echo e(request()->routeIs('company_management.index') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة الشركات</p>
                        </a>
                    </li>
                    <?php if(auth()->user()->position == 'super_admin' || auth()->user()->company_id == null): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('company_management.create')); ?>" class="nav-link <?php echo e(request()->routeIs('company_management.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus nav-icon"></i>
                            <p>إضافة شركة جديدة</p>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            <!-- الإعدادات -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('manage_settings') || auth()->user()->hasPermission('view_settings') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('tax_settings.*') || request()->routeIs('company_settings.*') || request()->routeIs('notification-settings.*') || request()->routeIs('inventory.alerts.settings') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('tax_settings.*') || request()->routeIs('company_settings.*') || request()->routeIs('notification-settings.*') || request()->routeIs('inventory.alerts.settings') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-cogs"></i>
                    <p>
                        الإعدادات
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('tax_settings.index')); ?>" class="nav-link <?php echo e(request()->routeIs('tax_settings.index') ? 'active' : ''); ?>">    
                            <i class="fas fa-percent nav-icon"></i>
                            <p>إعدادات الضرائب</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('company_settings.index')); ?>" class="nav-link <?php echo e(request()->routeIs('company_settings.index') ? 'active' : ''); ?>">
                            <i class="fas fa-cog nav-icon"></i>
                            <p>الإعدادات العامة</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('notification-settings.index')); ?>" class="nav-link <?php echo e(request()->routeIs('notification-settings.index') ? 'active' : ''); ?>">
                            <i class="fas fa-bell nav-icon"></i>
                            <p>إعدادات الإشعارات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.alerts.settings')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.alerts.settings') ? 'active' : ''); ?>">
                            <i class="fas fa-exclamation-triangle nav-icon"></i>
                            <p>إعدادات تنبيهات المخزون</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- النظام المحاسبي -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_accounting') || auth()->user()->hasPermission('manage_accounting') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('accounting.*') || request()->routeIs('chart-of-accounts.*') || request()->routeIs('journal-entries.*') || request()->routeIs('journal-templates.*') || request()->routeIs('fiscal-years.*') || request()->routeIs('accounting-periods.*') || request()->routeIs('financial-statements.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('accounting.*') || request()->routeIs('chart-of-accounts.*') || request()->routeIs('journal-entries.*') || request()->routeIs('journal-templates.*') || request()->routeIs('fiscal-years.*') || request()->routeIs('accounting-periods.*') || request()->routeIs('financial-statements.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-calculator"></i>
                    <p>
                        النظام المحاسبي
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('accounting.dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('accounting.dashboard') ? 'active' : ''); ?>">
                            <i class="fas fa-tachometer-alt nav-icon"></i>
                            <p>لوحة التحكم المحاسبية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('chart-of-accounts.index')); ?>" class="nav-link <?php echo e(request()->routeIs('chart-of-accounts.index') ? 'active' : ''); ?>">
                            <i class="fas fa-book nav-icon"></i>
                            <p>دليل الحسابات</p>
                        </a>
                    </li>
                    
                    <?php if(auth()->user()->hasPermission('manage_accounting') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('chart-of-accounts.create')); ?>" class="nav-link <?php echo e(request()->routeIs('chart-of-accounts.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة حساب جديد</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('chart-of-accounts.tree')); ?>" class="nav-link <?php echo e(request()->routeIs('chart-of-accounts.tree') ? 'active' : ''); ?>">
                            <i class="fas fa-sitemap nav-icon"></i>
                            <p>شجرة الحسابات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('journal-entries.index')); ?>" class="nav-link <?php echo e(request()->routeIs('journal-entries.index') ? 'active' : ''); ?>">
                            <i class="fas fa-file-invoice nav-icon"></i>
                            <p>القيود المحاسبية</p>
                        </a>
                    </li>
                    
                    <?php if(auth()->user()->hasPermission('manage_accounting') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('journal-entries.create')); ?>" class="nav-link <?php echo e(request()->routeIs('journal-entries.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة قيد محاسبي</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('journal-templates.index')); ?>" class="nav-link <?php echo e(request()->routeIs('journal-templates.index') ? 'active' : ''); ?>">
                            <i class="fas fa-copy nav-icon"></i>
                            <p>قوالب القيود المحاسبية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('ledger.index')); ?>" class="nav-link <?php echo e(request()->routeIs('ledger.*') ? 'active' : ''); ?>">
                            <i class="fas fa-book nav-icon"></i>
                            <p>دفتر الأستاذ (كشف الحساب)</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('fiscal-years.index')); ?>" class="nav-link <?php echo e(request()->routeIs('fiscal-years.index') ? 'active' : ''); ?>">
                            <i class="fas fa-calendar-alt nav-icon"></i>
                            <p>السنوات المالية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('accounting-periods.index')); ?>" class="nav-link <?php echo e(request()->routeIs('accounting-periods.index') ? 'active' : ''); ?>">
                            <i class="fas fa-calendar-week nav-icon"></i>
                            <p>الفترات المحاسبية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('financial-statements.income-statement')); ?>" class="nav-link <?php echo e(request()->routeIs('financial-statements.income-statement') ? 'active' : ''); ?>">
                            <i class="fas fa-file-invoice-dollar nav-icon"></i>
                            <p>قائمة الدخل</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('financial-statements.balance-sheet')); ?>" class="nav-link <?php echo e(request()->routeIs('financial-statements.balance-sheet') ? 'active' : ''); ?>">
                            <i class="fas fa-balance-scale nav-icon"></i>
                            <p>الميزانية العمومية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('financial-statements.cash-flow')); ?>" class="nav-link <?php echo e(request()->routeIs('financial-statements.cash-flow') ? 'active' : ''); ?>">
                            <i class="fas fa-money-bill-wave nav-icon"></i>
                            <p>التدفقات النقدية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('chart-of-accounts.trial-balance')); ?>" class="nav-link <?php echo e(request()->routeIs('chart-of-accounts.trial-balance') ? 'active' : ''); ?>">
                            <i class="fas fa-list-ol nav-icon"></i>
                            <p>ميزان المراجعة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('account-balance-report.index')); ?>" class="nav-link <?php echo e(request()->routeIs('account-balance-report.index') ? 'active' : ''); ?>">
                            <i class="fas fa-coins nav-icon"></i>
                            <p>تقرير أرصدة الحسابات</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>
            
            <!-- نظام البنوك -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('manage_banks') || auth()->user()->hasPermission('view_bank') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 6)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('banks.*') || request()->routeIs('bank-accounts.*') || request()->routeIs('bank-transactions.*') || request()->routeIs('cheques.*') || request()->routeIs('bank-reconciliations.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('banks.*') || request()->routeIs('bank-accounts.*') || request()->routeIs('bank-transactions.*') || request()->routeIs('cheques.*') || request()->routeIs('bank-reconciliations.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-university"></i>
                    <p>
                        نظام البنوك
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('banks.index')); ?>" class="nav-link <?php echo e(request()->routeIs('banks.index') ? 'active' : ''); ?>">
                            <i class="fas fa-university nav-icon"></i>
                            <p>قائمة البنوك</p>
                        </a>
                    </li>
                    
                    <?php if(auth()->user()->hasPermission('create_bank') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 6): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('banks.create')); ?>" class="nav-link <?php echo e(request()->routeIs('banks.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة بنك جديد</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('bank-accounts.index')); ?>" class="nav-link <?php echo e(request()->routeIs('bank-accounts.index') ? 'active' : ''); ?>">
                            <i class="fas fa-money-check-alt nav-icon"></i>
                            <p>الحسابات البنكية</p>
                        </a>
                    </li>
                    
                    <?php if(auth()->user()->hasPermission('create_bank_account') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 6): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('bank-accounts.create')); ?>" class="nav-link <?php echo e(request()->routeIs('bank-accounts.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة حساب بنكي جديد</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('bank-transactions.index')); ?>" class="nav-link <?php echo e(request()->routeIs('bank-transactions.index') ? 'active' : ''); ?>">
                            <i class="fas fa-exchange-alt nav-icon"></i>
                            <p>المعاملات البنكية</p>
                        </a>
                    </li>
                    
                    <?php if(auth()->user()->hasPermission('view_bank_transaction') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 6): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('bank-transactions.create-deposit')); ?>" class="nav-link <?php echo e(request()->routeIs('bank-transactions.create-deposit') ? 'active' : ''); ?>">
                            <i class="fas fa-arrow-circle-down nav-icon"></i>
                            <p>إيداع جديد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('bank-transactions.create-withdrawal')); ?>" class="nav-link <?php echo e(request()->routeIs('bank-transactions.create-withdrawal') ? 'active' : ''); ?>">
                            <i class="fas fa-arrow-circle-up nav-icon"></i>
                            <p>سحب جديد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('bank-transactions.create-transfer')); ?>" class="nav-link <?php echo e(request()->routeIs('bank-transactions.create-transfer') ? 'active' : ''); ?>">
                            <i class="fas fa-random nav-icon"></i>
                            <p>تحويل جديد</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('cheques.index')); ?>" class="nav-link <?php echo e(request()->routeIs('cheques.index') ? 'active' : ''); ?>">
                            <i class="fas fa-money-check nav-icon"></i>
                            <p>الشيكات</p>
                        </a>
                    </li>
                    
                    <?php if(auth()->user()->hasPermission('create_cheque') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 6): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('cheques.create-incoming')); ?>" class="nav-link <?php echo e(request()->routeIs('cheques.create-incoming') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة شيك وارد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('cheques.create-outgoing')); ?>" class="nav-link <?php echo e(request()->routeIs('cheques.create-outgoing') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة شيك صادر</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('bank-reconciliations.index')); ?>" class="nav-link <?php echo e(request()->routeIs('bank-reconciliations.index') ? 'active' : ''); ?>">
                            <i class="fas fa-balance-scale nav-icon"></i>
                            <p>التسويات البنكية</p>
                        </a>
                    </li>
                    
                    <?php if(auth()->user()->hasPermission('perform_bank_reconciliation') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 6): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('bank-reconciliations.create')); ?>" class="nav-link <?php echo e(request()->routeIs('bank-reconciliations.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إنشاء تسوية بنكية جديدة</p>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>
            
            <!-- نظام محاضر تسليم المصاعد -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_elevator_deliveries') || auth()->user()->hasPermission('manage_elevator_deliveries') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('elevator-deliveries.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('elevator-deliveries.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-clipboard-check"></i>
                    <p>
                        محاضر تسليم المصاعد
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('elevator-deliveries.index')); ?>" class="nav-link <?php echo e(request()->routeIs('elevator-deliveries.index') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة محاضر التسليم</p>
                        </a>
                    </li>
                    <?php if(auth()->user()->hasPermission('manage_elevator_deliveries') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('elevator-deliveries.create')); ?>" class="nav-link <?php echo e(request()->routeIs('elevator-deliveries.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة محضر تسليم جديد</p>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>
            
            <!-- نظام إدارة الخزينة -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_cash_management') || auth()->user()->hasPermission('manage_cash_management') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('cash-registers.*') || request()->routeIs('cash-transactions.*') || request()->routeIs('cash-deposits.*') || request()->routeIs('cash-withdrawals.*') || request()->routeIs('cash-reports.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('cash-registers.*') || request()->routeIs('cash-transactions.*') || request()->routeIs('cash-deposits.*') || request()->routeIs('cash-withdrawals.*') || request()->routeIs('cash-reports.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-cash-register"></i>
                    <p>
                        إدارة الخزينة
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('cash-registers.index')); ?>" class="nav-link <?php echo e(request()->routeIs('cash-registers.index') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة الخزائن</p>
                        </a>
                    </li>
                    
                    <?php if(auth()->user()->hasPermission('manage_cash_management') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('cash-registers.create')); ?>" class="nav-link <?php echo e(request()->routeIs('cash-registers.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة خزينة جديدة</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('cash-deposits.index')); ?>" class="nav-link <?php echo e(request()->routeIs('cash-deposits.*') ? 'active' : ''); ?>">
                            <i class="fas fa-arrow-circle-down nav-icon"></i>
                            <p>إيداعات الخزينة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('cash-withdrawals.index')); ?>" class="nav-link <?php echo e(request()->routeIs('cash-withdrawals.*') ? 'active' : ''); ?>">
                            <i class="fas fa-arrow-circle-up nav-icon"></i>
                            <p>سحوبات الخزينة</p>
                        </a>
                    </li>
                    
                    <?php if(auth()->user()->hasPermission('manage_cash_management') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('cash-deposits.create')); ?>" class="nav-link <?php echo e(request()->routeIs('cash-deposits.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة إيداع جديد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('cash-withdrawals.create')); ?>" class="nav-link <?php echo e(request()->routeIs('cash-withdrawals.create') ? 'active' : ''); ?>">
                            <i class="fas fa-minus-circle nav-icon"></i>
                            <p>إضافة سحب جديد</p>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            <!-- إدارة المصاعد -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_elevators') || auth()->user()->hasPermission('manage_elevators') || auth()->user()->hasPermission('elevator_models.view') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('elevators.*') || request()->routeIs('elevator-models.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('elevators.*') || request()->routeIs('elevator-models.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-elevator"></i>
                    <p>
                        إدارة المصاعد
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('elevators.index')); ?>" class="nav-link <?php echo e(request()->routeIs('elevators.index') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة المصاعد</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('elevators.create')); ?>" class="nav-link <?php echo e(request()->routeIs('elevators.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة مصعد جديد</p>
                        </a>
                    </li>
                    <?php if(auth()->check() && (auth()->user()->hasPermission('elevator_models.view') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('elevator-models.index')); ?>" class="nav-link <?php echo e(request()->routeIs('elevator-models.index') ? 'active' : ''); ?>">
                            <i class="fas fa-cubes nav-icon"></i>
                            <p>موديلات المصاعد</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(auth()->check() && (auth()->user()->hasPermission('elevator_models.create') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('elevator-models.create')); ?>" class="nav-link <?php echo e(request()->routeIs('elevator-models.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة موديل جديد</p>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            <!-- إدارة المشروعات -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_projects') || auth()->user()->hasPermission('manage_projects') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('installation-projects.*') || request()->routeIs('elevator-stages.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('installation-projects.*') || request()->routeIs('elevator-stages.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-project-diagram"></i>
                    <p>
                        إدارة المشروعات
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('installation-projects.index')); ?>" class="nav-link <?php echo e(request()->routeIs('installation-projects.index') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة المشروعات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('installation-projects.create')); ?>" class="nav-link <?php echo e(request()->routeIs('installation-projects.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة مشروع جديد</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('elevator-stages.index')); ?>" class="nav-link <?php echo e(request()->routeIs('elevator-stages.index') ? 'active' : ''); ?>">
                            <i class="fas fa-layer-group nav-icon"></i>
                            <p>مراحل المصاعد</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('elevator-stages.create')); ?>" class="nav-link <?php echo e(request()->routeIs('elevator-stages.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة مرحلة جديدة</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- إدارة الفواتير -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_invoices') || auth()->user()->hasPermission('manage_invoices') || auth()->user()->hasPermission('view_sales_returns') || auth()->user()->hasPermission('manage_sales_returns') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('invoices.*') || request()->routeIs('invoice-templates.*') || request()->routeIs('invoice-installments.*') || request()->routeIs('sales-returns.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('invoices.*') || request()->routeIs('invoice-templates.*') || request()->routeIs('invoice-installments.*') || request()->routeIs('sales-returns.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-file-invoice"></i>
                    <p>
                        إدارة الفواتير
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('invoices.index')); ?>" class="nav-link <?php echo e(request()->routeIs('invoices.index') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة الفواتير</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('invoices.create')); ?>" class="nav-link <?php echo e(request()->routeIs('invoices.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة فاتورة جديدة</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('invoice-templates.index')); ?>" class="nav-link <?php echo e(request()->routeIs('invoice-templates.index') ? 'active' : ''); ?>">
                            <i class="fas fa-copy nav-icon"></i>
                            <p>قوالب الفواتير</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('invoice-installments.index')); ?>" class="nav-link <?php echo e(request()->routeIs('invoice-installments.index') ? 'active' : ''); ?>">
                            <i class="fas fa-money-bill-wave nav-icon"></i>
                            <p>أقساط الفواتير</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('sales-returns.index')); ?>" class="nav-link <?php echo e(request()->routeIs('sales-returns.index') ? 'active' : ''); ?>">
                            <i class="fas fa-undo nav-icon"></i>
                            <p>مرتجعات المبيعات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('sales-returns.create')); ?>" class="nav-link <?php echo e(request()->routeIs('sales-returns.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إنشاء مرتجع مبيعات جديد</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- إدارة جداول الصيانة -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_maintenance') || auth()->user()->hasPermission('manage_maintenance') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('maintenance-schedules.*') || request()->routeIs('maintenance-logs.*') || request()->routeIs('maintenance-notifications.*') || request()->routeIs('maintenance-contracts.*') || request()->routeIs('maintenance-calendar.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('maintenance-schedules.*') || request()->routeIs('maintenance-logs.*') || request()->routeIs('maintenance-notifications.*') || request()->routeIs('maintenance-contracts.*') || request()->routeIs('maintenance-calendar.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-tools"></i>
                    <p>
                        إدارة جداول الصيانة
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('maintenance-schedules.index')); ?>" class="nav-link <?php echo e(request()->routeIs('maintenance-schedules.index') && !request()->has('show_generate') ? 'active' : ''); ?>">
                            <i class="fas fa-calendar-alt nav-icon"></i>
                            <p>جداول الصيانة</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('maintenance-schedules.index')); ?>?show_generate=1" class="nav-link <?php echo e(request()->routeIs('maintenance-schedules.index') && request()->has('show_generate') ? 'active' : ''); ?>">
                            <i class="fas fa-calendar-plus nav-icon"></i>
                            <p>إنشاء جداول صيانة دورية متعددة</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('maintenance-schedules.create')); ?>" class="nav-link <?php echo e(request()->routeIs('maintenance-schedules.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة جدول صيانة جديد</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('maintenance-logs.index')); ?>" class="nav-link <?php echo e(request()->routeIs('maintenance-logs.index') ? 'active' : ''); ?>">
                            <i class="fas fa-clipboard-list nav-icon"></i>
                            <p>سجلات الصيانة</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('maintenance-contracts.index')); ?>" class="nav-link <?php echo e(request()->routeIs('maintenance-contracts.*') ? 'active' : ''); ?>">
                            <i class="fas fa-file-contract nav-icon"></i>
                            <p>عقود الصيانة الدورية</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('maintenance-calendar.index')); ?>" class="nav-link <?php echo e(request()->routeIs('maintenance-calendar.*') ? 'active' : ''); ?>">
                            <i class="fas fa-calendar nav-icon"></i>
                            <p>تقويم الصيانة الدورية</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('maintenance-notifications.index')); ?>" class="nav-link <?php echo e(request()->routeIs('maintenance-notifications.index') ? 'active' : ''); ?>">
                            <i class="fas fa-bell nav-icon"></i>
                            <p>إشعارات الصيانة</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- الدفاع المدني -->
            <?php if(auth()->check() && auth()->user()->hasPermission('view_civil_defense')): ?>
            <li class="nav-item <?php echo e(request()->routeIs('civil-defense.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('civil-defense.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-fire-extinguisher"></i>
                    <p>
                        الدفاع المدني
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <?php if(auth()->user()->hasPermission('view_termination_letters')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('civil-defense.termination-letters.index')); ?>" class="nav-link <?php echo e(request()->routeIs('civil-defense.termination-letters.*') ? 'active' : ''); ?>">
                            <i class="fas fa-file-alt nav-icon"></i>
                            <p>خطابات إنهاء الصيانة</p>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            <!-- إدارة الموارد البشرية -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_hrm') || auth()->user()->hasPermission('manage_hrm') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9 || auth()->user()->id == 3)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('hrm.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('hrm.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-user-friends"></i>
                    <p>
                        الموارد البشرية
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('hrm.employees.index')); ?>" class="nav-link <?php echo e(request()->routeIs('hrm.employees.*') ? 'active' : ''); ?>">
                            <i class="fas fa-users nav-icon"></i>
                            <p>الموظفين</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('hrm.departments.index')); ?>" class="nav-link <?php echo e(request()->routeIs('hrm.departments.*') ? 'active' : ''); ?>">
                            <i class="fas fa-building nav-icon"></i>
                            <p>الأقسام</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('hrm.attendance.index')); ?>" class="nav-link <?php echo e(request()->routeIs('hrm.attendance.*') ? 'active' : ''); ?>">
                            <i class="fas fa-calendar-check nav-icon"></i>
                            <p>الحضور والانصراف</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('hrm.leaves.index')); ?>" class="nav-link <?php echo e(request()->routeIs('hrm.leaves.*') ? 'active' : ''); ?>">
                            <i class="fas fa-calendar-minus nav-icon"></i>
                            <p>الإجازات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="<?php echo e(route('hrm.payroll.index')); ?>" class="nav-link <?php echo e(request()->routeIs('hrm.payroll.*') ? 'active' : ''); ?>">
                            <i class="fas fa-money-check-alt nav-icon"></i>
                            <p>الرواتب</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- إدارة العملاء -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_customers') || auth()->user()->hasPermission('manage_customers') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('customers.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('customers.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-users"></i>
                    <p>
                        إدارة العملاء
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('customers.index')); ?>" class="nav-link <?php echo e(request()->routeIs('customers.index') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة العملاء</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('customers.create')); ?>" class="nav-link <?php echo e(request()->routeIs('customers.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة عميل جديد</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- إدارة العقود -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_contracts') || auth()->user()->hasPermission('manage_contracts') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('maintenance-contracts.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('maintenance-contracts.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-file-contract"></i>
                    <p>
                        إدارة العقود
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('maintenance-contracts.index')); ?>" class="nav-link <?php echo e(request()->routeIs('maintenance-contracts.index') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة العقود</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('maintenance-contracts.create')); ?>" class="nav-link <?php echo e(request()->routeIs('maintenance-contracts.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة عقد جديد</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- إدارة المخزون -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_inventory') || auth()->user()->hasPermission('manage_inventory') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9 || auth()->user()->email == 'user3@user3.com')): ?>
            <li class="nav-item <?php echo e(request()->routeIs('inventory.*') || request()->routeIs('inventory.items.*') || request()->routeIs('inventory.dashboard') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('inventory.*') || request()->routeIs('inventory.items.*') || request()->routeIs('inventory.dashboard') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-warehouse"></i>
                    <p>
                        إدارة المخزون
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.dashboard') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة المخزون</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.items.create')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.items.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة عنصر جديد</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.warehouses.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.warehouses.index') ? 'active' : ''); ?>">
                            <i class="fas fa-building nav-icon"></i>
                            <p>المستودعات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.categories.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.categories.index') ? 'active' : ''); ?>">
                            <i class="fas fa-tags nav-icon"></i>
                            <p>فئات المخزون</p>
                        </a>
                    </li>
                    <!-- وحدات المخزون - متاح للمستخدم user3 -->
                    <?php if(auth()->check() && (auth()->user()->hasPermission('view_inventory') || auth()->user()->hasPermission('manage_inventory') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9 || auth()->user()->email == 'user3@user3.com')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.units.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.units.*') ? 'active' : ''); ?>">
                            <i class="fas fa-ruler nav-icon"></i>
                            <p>وحدات المخزون</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.stock.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.stock.index') ? 'active' : ''); ?>">
                            <i class="fas fa-boxes nav-icon"></i>
                            <p>مخزون المستودعات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.counts.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.counts.index') ? 'active' : ''); ?>">
                            <i class="fas fa-clipboard-check nav-icon"></i>
                            <p>جرد المخزون</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.barcodes.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.barcodes.index') ? 'active' : ''); ?>">
                            <i class="fas fa-barcode nav-icon"></i>
                            <p>إدارة الباركود</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.valuation.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.valuation.index') ? 'active' : ''); ?>">
                            <i class="fas fa-calculator nav-icon"></i>
                            <p>تقييم المخزون</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory-issues.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory-issues.*') ? 'active' : ''); ?>">
                            <i class="fas fa-file-export nav-icon"></i>
                            <p>أذونات الصرف</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('elevator-inventory.index')); ?>" class="nav-link <?php echo e(request()->routeIs('elevator-inventory.*') ? 'active' : ''); ?>">
                            <i class="fas fa-elevator nav-icon"></i>
                            <p>صرف بضاعة للمصاعد</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>
            
            <!-- نظام المشتريات - متاح للمستخدم user3 -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_purchases') || auth()->user()->hasPermission('manage_purchases') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9 || auth()->user()->email == 'user3@user3.com')): ?>
            <li class="nav-item <?php echo e(request()->routeIs('inventory.purchase-orders.*') || request()->routeIs('inventory.suppliers.*') || request()->routeIs('inventory.auto-purchase.*') || request()->routeIs('inventory.purchase-returns.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('inventory.purchase-orders.*') || request()->routeIs('inventory.suppliers.*') || request()->routeIs('inventory.auto-purchase.*') || request()->routeIs('inventory.purchase-returns.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-shopping-cart"></i>
                    <p>
                        نظام المشتريات
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.purchase-orders.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.purchase-orders.index') ? 'active' : ''); ?>">
                            <i class="fas fa-file-invoice nav-icon"></i>
                            <p>أوامر الشراء</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.purchase-orders.create')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.purchase-orders.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إنشاء أمر شراء جديد</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.suppliers.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.suppliers.index') ? 'active' : ''); ?>">
                            <i class="fas fa-truck nav-icon"></i>
                            <p>الموردين</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.suppliers.create')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.suppliers.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة مورد جديد</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.auto-purchase.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.auto-purchase.index') ? 'active' : ''); ?>">
                            <i class="fas fa-magic nav-icon"></i>
                            <p>قواعد الشراء التلقائي</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.auto-purchase.create')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.auto-purchase.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة قاعدة شراء تلقائي</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.auto-purchase.run-check')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.auto-purchase.run-check') ? 'active' : ''); ?>">
                            <i class="fas fa-play nav-icon"></i>
                            <p>تشغيل فحص الشراء التلقائي</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.auto-purchase.analytics')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.auto-purchase.analytics') ? 'active' : ''); ?>">
                            <i class="fas fa-chart-line nav-icon"></i>
                            <p>تحليلات الشراء</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.transactions.index')); ?>?type=purchase" class="nav-link <?php echo e(request()->routeIs('inventory.transactions.index') && request()->query('type') == 'purchase' ? 'active' : ''); ?>">
                            <i class="fas fa-exchange-alt nav-icon"></i>
                            <p>سجل عمليات الشراء</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.purchase-invoices.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.purchase-invoices.index') ? 'active' : ''); ?>">
                            <i class="fas fa-file-invoice-dollar nav-icon"></i>
                            <p>فواتير المشتريات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.purchase-invoices.create')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.purchase-invoices.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إنشاء فاتورة مشتريات جديدة</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.purchase-invoice-payments.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.purchase-invoice-payments.index') ? 'active' : ''); ?>">
                            <i class="fas fa-money-bill-wave nav-icon"></i>
                            <p>مدفوعات فواتير المشتريات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.purchase-returns.index')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.purchase-returns.index') ? 'active' : ''); ?>">
                            <i class="fas fa-undo nav-icon"></i>
                            <p>مرتجعات المشتريات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('inventory.purchase-returns.create')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.purchase-returns.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إنشاء مرتجع مشتريات جديد</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- إدارة أوامر العمل -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_work_orders') || auth()->user()->hasPermission('manage_work_orders') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('work-orders.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('work-orders.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-tasks"></i>
                    <p>
                        أوامر العمل
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('work-orders.index')); ?>" class="nav-link <?php echo e(request()->routeIs('work-orders.index') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة أوامر العمل</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('work-orders.create')); ?>" class="nav-link <?php echo e(request()->routeIs('work-orders.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة أمر عمل جديد</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- إدارة الفروع -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_branches') || auth()->user()->hasPermission('manage_branches') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('branches.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('branches.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-code-branch"></i>
                    <p>
                        إدارة الفروع
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('branches.index')); ?>" class="nav-link <?php echo e(request()->routeIs('branches.index') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة الفروع</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('branches.create')); ?>" class="nav-link <?php echo e(request()->routeIs('branches.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة فرع جديد</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- إدارة المواقع -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_locations') || auth()->user()->hasPermission('manage_locations') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('locations.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('locations.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-map-marker-alt"></i>
                    <p>
                        إدارة المواقع
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('locations.index')); ?>" class="nav-link <?php echo e(request()->routeIs('locations.index') ? 'active' : ''); ?>">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة المواقع</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('locations.create')); ?>" class="nav-link <?php echo e(request()->routeIs('locations.create') ? 'active' : ''); ?>">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة موقع جديد</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- التقارير -->
            <?php if(auth()->check() && (auth()->user()->hasPermission('view_reports') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->id == 9)): ?>
            <li class="nav-item <?php echo e(request()->routeIs('reports.*') ? 'menu-open' : ''); ?>">
                <a href="#" class="nav-link <?php echo e(request()->routeIs('reports.*') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-chart-bar"></i>
                    <p>
                        التقارير
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="<?php echo e(route('reports.sales')); ?>" class="nav-link <?php echo e(request()->routeIs('reports.sales') ? 'active' : ''); ?>">
                            <i class="fas fa-chart-line nav-icon"></i>
                            <p>تقارير المبيعات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('reports.maintenance')); ?>" class="nav-link <?php echo e(request()->routeIs('reports.maintenance') ? 'active' : ''); ?>">
                            <i class="fas fa-tools nav-icon"></i>
                            <p>تقارير الصيانة</p>
                        </a>
                    </li>
                    <li class="nav-item <?php echo e(request()->routeIs('inventory.reports.*') ? 'menu-open' : ''); ?>">
                        <a href="#" class="nav-link <?php echo e(request()->routeIs('inventory.reports.*') ? 'active' : ''); ?>">
                            <i class="fas fa-warehouse nav-icon"></i>
                            <p>
                                تقارير المخزون
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('inventory.reports.stock-value')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.reports.stock-value') ? 'active' : ''); ?>">
                                    <i class="fas fa-coins nav-icon"></i>
                                    <p>تقرير قيمة المخزون</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('inventory.reports.stock-movement')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.reports.stock-movement') ? 'active' : ''); ?>">
                                    <i class="fas fa-exchange-alt nav-icon"></i>
                                    <p>تقرير حركة المخزون</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('inventory.reports.item-movement')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.reports.item-movement') ? 'active' : ''); ?>">
                                    <i class="fas fa-box-open nav-icon"></i>
                                    <p>تقرير حركة صنف</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('inventory.reports.low-stock')); ?>" class="nav-link <?php echo e(request()->routeIs('inventory.reports.low-stock') ? 'active' : ''); ?>">
                                    <i class="fas fa-exclamation-triangle nav-icon"></i>
                                    <p>تقرير الأصناف منخفضة المخزون</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('reports.inventory')); ?>" class="nav-link <?php echo e(request()->routeIs('reports.inventory') ? 'active' : ''); ?>">
                                    <i class="fas fa-file-alt nav-icon"></i>
                                    <p>تقارير المخزون الأخرى</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('reports.financial')); ?>" class="nav-link <?php echo e(request()->routeIs('reports.financial') ? 'active' : ''); ?>">
                            <i class="fas fa-money-bill-wave nav-icon"></i>
                            <p>التقارير المالية</p>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <li class="nav-item">
                <a href="#" class="nav-link logout-sidebar-btn" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    <i class="nav-icon fas fa-sign-out-alt text-danger"></i>
                    <p class="text-danger font-weight-bold">
                        تسجيل الخروج
                    </p>
                </a>
                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                    <?php echo csrf_field(); ?>
                </form>
            </li>
        </ul>
    </nav>
</div><?php /**PATH D:\xampp8-2-new\htdocs\elevators_erp-m\resources\views/layouts/partials/sidebar.blade.php ENDPATH**/ ?>