<?php $__env->startSection('title', 'أوامر الشغل'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">أوامر الشغل</h3>
                    <div class="card-tools">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('work_orders.view')): ?>
                        <a href="<?php echo e(route('work-orders.export', request()->all())); ?>" class="btn btn-success btn-sm">
                            <i class="fas fa-file-excel"></i> تصدير إلى إكسيل
                        </a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('work_orders.create')): ?>
                        <a href="<?php echo e(route('work-orders.create')); ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة أمر شغل جديد
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <!-- Filter Form -->
                    <div class="card card-outline card-primary mb-4">
                        <div class="card-body">
                            <form action="<?php echo e(route('work-orders.index')); ?>" method="GET">
                                <div class="row">
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label for="elevator_number">رقم المصعد</label>
                                            <input type="text" name="elevator_number" id="elevator_number" class="form-control" value="<?php echo e(request('elevator_number')); ?>" placeholder="رقم المصعد">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label for="customer_name">اسم العميل</label>
                                            <input type="text" name="customer_name" id="customer_name" class="form-control" value="<?php echo e(request('customer_name')); ?>" placeholder="اسم العميل">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="stage_name">اسم المرحلة</label>
                                            <select name="stage_name" id="stage_name" class="form-control">
                                                <option value="">اختر المرحلة</option>
                                                <?php $__currentLoopData = $elevatorStages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($stage->id); ?>" <?php echo e(request('stage_name') == $stage->id ? 'selected' : ''); ?>><?php echo e($stage->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label for="status">الحالة</label>
                                            <select name="status" id="status" class="form-control">
                                                <option value="">كل الحالات</option>
                                                <option value="open" <?php echo e(request('status') == 'open' ? 'selected' : ''); ?>>مفتوح</option>
                                                <option value="paused" <?php echo e(request('status') == 'paused' ? 'selected' : ''); ?>>متوقف</option>
                                                <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>مكتمل</option>
                                                <option value="archived" <?php echo e(request('status') == 'archived' ? 'selected' : ''); ?>>مؤرشف</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <div>
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fas fa-search"></i> بحث
                                                </button>
                                                <a href="<?php echo e(route('work-orders.index')); ?>" class="btn btn-secondary">
                                                    <i class="fas fa-undo"></i> إعادة تعيين
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>المصعد</th>
                                    <th>العميل</th>
                                    <th>مرحلة المصعد</th>
                                    <th>جاهز فنياً</th>
                                    <th>الفني المسؤول</th>
                                    <th>الحالة</th>
                                    <th>تاريخ الأمر</th>
                                    <th>تاريخ الاستلام</th>
                                    <th>تاريخ الإنجاز</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $workOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $workOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($workOrder->id); ?></td>
                                        <td><?php echo e($workOrder->elevator->model); ?> - <?php echo e($workOrder->elevator->serial_number); ?></td>
                                        <td><?php echo e($workOrder->elevator->customer->name); ?></td>
                                        <td><?php echo e($workOrder->elevatorStage ? $workOrder->elevatorStage->name : '-'); ?></td>
                                        <td>
                                            <?php if($workOrder->is_technically_ready): ?>
                                                <span class="badge badge-success">جاهز</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">غير جاهز</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($workOrder->technician ? $workOrder->technician->name : '-'); ?></td>
                                        <td>
                                            <span class="badge 
                                                <?php if($workOrder->status == 'open'): ?> badge-success
                                                <?php elseif($workOrder->status == 'paused'): ?> badge-warning
                                                <?php elseif($workOrder->status == 'completed'): ?> badge-info
                                                <?php elseif($workOrder->status == 'archived'): ?> badge-secondary
                                                <?php endif; ?>">
                                                <?php echo e($workOrder->status_text); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e($workOrder->order_date->format('Y-m-d')); ?></td>
                                        <td><?php echo e($workOrder->received_date ? $workOrder->received_date->format('Y-m-d') : '-'); ?></td>
                                        <td><?php echo e($workOrder->completion_date ? $workOrder->completion_date->format('Y-m-d') : '-'); ?></td>
                                        <td>
                                            <div class="btn-group">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('work_orders.view')): ?>
                                                <a href="<?php echo e(route('work-orders.show', $workOrder->id)); ?>" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <?php endif; ?>
                                                
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('work_orders.edit')): ?>
                                                <a href="<?php echo e(route('work-orders.edit', $workOrder->id)); ?>" class="btn btn-primary btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <?php endif; ?>
                                                
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('work_orders.delete')): ?>
                                                <form action="<?php echo e(route('work-orders.destroy', $workOrder->id)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذا الأمر؟')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="10" class="text-center">لا توجد أوامر شغل</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4">
                        <?php echo e($workOrders->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp8-2-new\htdocs\elevators_erp-m\resources\views/work_orders/index.blade.php ENDPATH**/ ?>