<?php

use App\Http\Controllers\ZatcaController;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['auth']], function () {
    // مسارات الفوترة الإلكترونية
    Route::get('/zatca', [ZatcaController::class, 'index'])->name('zatca.index');
    Route::get('/zatca/{id}', [ZatcaController::class, 'show'])->name('zatca.show');
    Route::post('/zatca/{id}/update-type', [ZatcaController::class, 'updateInvoiceType'])->name('zatca.update-type');
    Route::get('/zatca/{id}/generate-qr', [ZatcaController::class, 'generateQrCode'])->name('zatca.generate-qr');
    Route::get('/zatca/{id}/generate-xml', [ZatcaController::class, 'generateXml'])->name('zatca.generate-xml');
    Route::get('/zatca/{id}/report', [ZatcaController::class, 'reportInvoice'])->name('zatca.report');
    Route::get('/zatca/{id}/check-status', [ZatcaController::class, 'checkStatus'])->name('zatca.check-status');
});
