<?php

use App\Http\Controllers\PayrollController;
use App\Http\Controllers\SalaryPolicyController;
use App\Http\Controllers\TaxBracketController;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['auth', 'company'], 'prefix' => 'hrm', 'as' => 'hrm.'], function () {
    // Payroll routes
    Route::resource('payroll', PayrollController::class);

    // Approve payroll
    Route::post('payroll/{id}/approve', [PayrollController::class, 'approve'])->name('payroll.approve');

    // Process payroll payments
    Route::post('payroll/{id}/process-payments', [PayrollController::class, 'processPayments'])->name('payroll.process-payments');

    // Export payroll to PDF
    Route::get('payroll/{id}/export-pdf', [PayrollController::class, 'exportPdf'])->name('payroll.export-pdf');

    // Export payroll to Excel
    Route::get('payroll/{id}/export-excel', [PayrollController::class, 'exportExcel'])->name('payroll.export-excel');

    // Show employee payslip
    Route::get('payroll/{payrollId}/payslip/{employeeId}', [PayrollController::class, 'showPayslip'])->name('payroll.show-payslip');

    // Download employee payslip as PDF
    Route::get('payroll/{payrollId}/payslip/{employeeId}/download', [PayrollController::class, 'downloadPayslip'])->name('payroll.download-payslip');

    // Salary Policy Routes
    Route::resource('salary-policies', SalaryPolicyController::class);

    // Tax Bracket Routes
    Route::resource('tax-brackets', TaxBracketController::class);
});
