<?php

use App\Http\Controllers\HRM\LoanController;
use App\Http\Controllers\HRM\LoanInstallmentController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'company'])->prefix('hrm')->name('hrm.')->group(function () {
    // مسارات القروض
    Route::get('loans', [LoanController::class, 'index'])->name('loans.index');
    Route::get('loans/create', [LoanController::class, 'create'])->name('loans.create');
    Route::post('loans', [LoanController::class, 'store'])->name('loans.store');
    Route::get('loans/{loan}', [LoanController::class, 'show'])->name('loans.show');
    Route::get('loans/{loan}/edit', [LoanController::class, 'edit'])->name('loans.edit');
    Route::put('loans/{loan}', [LoanController::class, 'update'])->name('loans.update');
    Route::delete('loans/{loan}', [LoanController::class, 'destroy'])->name('loans.destroy');

    // مسارات إضافية للقروض
    Route::post('loans/{loan}/approve', [LoanController::class, 'approve'])->name('loans.approve');
    Route::post('loans/{loan}/reject', [LoanController::class, 'reject'])->name('loans.reject');
    Route::post('loans/{loan}/activate', [LoanController::class, 'activate'])->name('loans.activate');
    Route::post('loans/{loan}/complete', [LoanController::class, 'complete'])->name('loans.complete');
    Route::post('loans/{loan}/cancel', [LoanController::class, 'cancel'])->name('loans.cancel');

    // مسارات أقساط القروض
    Route::get('loan-installments', [LoanInstallmentController::class, 'index'])->name('loan-installments.index');
    Route::get('loan-installments/{installment}', [LoanInstallmentController::class, 'show'])->name('loan-installments.show');
    Route::get('loan-installments/{installment}/edit', [LoanInstallmentController::class, 'edit'])->name('loan-installments.edit');
    Route::put('loan-installments/{installment}', [LoanInstallmentController::class, 'update'])->name('loan-installments.update');

    // مسارات إضافية لأقساط القروض
    Route::post('loan-installments/{installment}/mark-as-paid', [LoanInstallmentController::class, 'markAsPaid'])->name('loan-installments.mark-as-paid');
    Route::post('loan-installments/{installment}/mark-as-overdue', [LoanInstallmentController::class, 'markAsOverdue'])->name('loan-installments.mark-as-overdue');
    Route::post('loan-installments/{installment}/cancel', [LoanInstallmentController::class, 'cancel'])->name('loan-installments.cancel');
    Route::post('loan-installments/update-overdue', [LoanInstallmentController::class, 'updateOverdueInstallments'])->name('loan-installments.update-overdue');
});
