<?php

use App\Http\Controllers\HRM\LeaveController;
use App\Http\Controllers\HRM\LeaveTypeController;
use App\Http\Controllers\HRM\LeaveBalanceController;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['auth', 'company'], 'prefix' => 'hrm', 'as' => 'hrm.'], function () {
    // Leave routes
    Route::resource('leaves', LeaveController::class);

    // Approve leave
    Route::post('leaves/{id}/approve', [LeaveController::class, 'approve'])->name('leaves.approve');

    // Reject leave
    Route::post('leaves/{id}/reject', [LeaveController::class, 'reject'])->name('leaves.reject');

    // Bulk approve leaves
    Route::post('leaves/bulk-approve', [LeaveController::class, 'bulkApprove'])->name('leaves.bulk-approve');

    // Bulk reject leaves
    Route::post('leaves/bulk-reject', [LeaveController::class, 'bulkReject'])->name('leaves.bulk-reject');

    // Leave calendar
    Route::get('leaves/calendar', [LeaveController::class, 'calendar'])->name('leaves.calendar');

    // Cancel leave
    Route::post('leaves/{id}/cancel', [LeaveController::class, 'cancel'])->name('leaves.cancel');

    // Leave types
    Route::resource('leave-types', LeaveTypeController::class);

    // Leave balances
    Route::resource('leave-balances', LeaveBalanceController::class);

    // Update all leave balances
    Route::post('leave-balances/update-all', [LeaveBalanceController::class, 'updateAllBalances'])->name('leave-balances.update-all');

    // Create new year balances
    Route::post('leave-balances/create-new-year', [LeaveBalanceController::class, 'createNewYearBalances'])->name('leave-balances.create-new-year');

    // Bulk create leave balances
    Route::get('leave-balances/bulk-create', [LeaveBalanceController::class, 'bulkCreate'])->name('leave-balances.bulk-create');
    Route::post('leave-balances/bulk-store', [LeaveBalanceController::class, 'bulkStore'])->name('leave-balances.bulk-store');

    // Leave balances report
    Route::get('leave-balances/report', [LeaveBalanceController::class, 'report'])->name('leave-balances.report');
});
