<?php

use App\Http\Controllers\HRM\EmployeeEvaluationController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'company'])->prefix('hrm/evaluations')->name('hrm.evaluations.')->group(function () {
    Route::get('/', [EmployeeEvaluationController::class, 'index'])->name('index');
    Route::get('/create', [EmployeeEvaluationController::class, 'create'])->name('create');
    Route::post('/', [EmployeeEvaluationController::class, 'store'])->name('store');
    Route::get('/{id}', [EmployeeEvaluationController::class, 'show'])->name('show');
    Route::get('/{id}/edit', [EmployeeEvaluationController::class, 'edit'])->name('edit');
    Route::put('/{id}', [EmployeeEvaluationController::class, 'update'])->name('update');
    Route::delete('/{id}', [EmployeeEvaluationController::class, 'destroy'])->name('destroy');

    // مسارات إضافية
    Route::post('/{id}/employee-comments', [EmployeeEvaluationController::class, 'addEmployeeComments'])->name('employee-comments');
    Route::get('/{id}/export-pdf', [EmployeeEvaluationController::class, 'exportPdf'])->name('export-pdf');
    Route::get('/report/view', [EmployeeEvaluationController::class, 'report'])->name('report');
});
