<?php

use App\Http\Controllers\HRM\EmployeeController;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['auth', 'company'], 'prefix' => 'hrm', 'as' => 'hrm.'], function () {
    // Employee routes
    Route::resource('employees', EmployeeController::class);

    // Import employees
    Route::post('employees/import', [EmployeeController::class, 'import'])->name('employees.import');

    // Export employees
    Route::get('employees/export', [EmployeeController::class, 'export'])->name('employees.export');
});
