<?php

use App\Http\Controllers\HRM\BonusController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'company'])->prefix('hrm')->name('hrm.')->group(function () {
    // مسارات المكافآت
    Route::get('bonuses', [BonusController::class, 'index'])->name('bonuses.index');
    Route::get('bonuses/create', [BonusController::class, 'create'])->name('bonuses.create');
    Route::post('bonuses', [BonusController::class, 'store'])->name('bonuses.store');
    Route::get('bonuses/{bonus}', [BonusController::class, 'show'])->name('bonuses.show');
    Route::get('bonuses/{bonus}/edit', [BonusController::class, 'edit'])->name('bonuses.edit');
    Route::put('bonuses/{bonus}', [BonusController::class, 'update'])->name('bonuses.update');
    Route::delete('bonuses/{bonus}', [BonusController::class, 'destroy'])->name('bonuses.destroy');

    // مسارات إضافية للمكافآت
    Route::post('bonuses/{bonus}/approve', [BonusController::class, 'approve'])->name('bonuses.approve');
    Route::post('bonuses/{bonus}/reject', [BonusController::class, 'reject'])->name('bonuses.reject');
    Route::post('bonuses/{bonus}/mark-as-paid', [BonusController::class, 'markAsPaid'])->name('bonuses.mark-as-paid');
});
