<?php

use App\Http\Controllers\HRM\AttendanceController;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['auth', 'company'], 'prefix' => 'hrm', 'as' => 'hrm.'], function () {
    // Attendance routes
    Route::resource('attendance', AttendanceController::class);

    // Import attendance
    Route::post('attendance/import', [AttendanceController::class, 'import'])->name('attendance.import');

    // Export attendance
    Route::get('attendance/export', [AttendanceController::class, 'export'])->name('attendance.export');

    // Monthly attendance report
    Route::get('attendance/report/monthly', [AttendanceController::class, 'monthlyReport'])->name('attendance.report.monthly');

    // Bulk check-in
    Route::post('attendance/bulk-check-in', [AttendanceController::class, 'bulkCheckIn'])->name('attendance.bulk-check-in');
});
