<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\CompanyManagementController;
use App\Http\Controllers\BranchController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\ElevatorController;
use App\Http\Controllers\ElevatorTypeController;
use App\Http\Controllers\ElevatorModelController;
use App\Http\Controllers\ElevatorPartController;
use App\Http\Controllers\MaintenanceContractController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\PaymentMethodController;
use App\Http\Controllers\MaintenanceScheduleController;
use App\Http\Controllers\MaintenanceLogController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\InvoiceTemplateController;
use App\Http\Controllers\InvoiceInstallmentController;
use App\Http\Controllers\TaxReportController;
use App\Http\Controllers\FinancialReportController;
use App\Http\Controllers\CustomerStatementController;
use App\Http\Controllers\AutoInvoiceController;
use App\Http\Controllers\PayrollController;
use App\Http\Controllers\SalaryPolicyController;
use App\Http\Controllers\TaxBracketController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

// Authentication routes
Auth::routes();

// تحديث صلاحيات المستخدم التجريبي
Route::get('/update-demo-user-roles', [App\Http\Controllers\Auth\UpdateDemoUserRolesController::class, 'updateDemoUserRoles'])
    ->name('update-demo-user-roles');

// Dashboard
Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

// Check Permissions (Temporary route for debugging)
Route::get('/check-permissions', function () {
    return view('check_permissions');
})->middleware('auth')->name('check.permissions');

// Temporary routes for managing user permissions
Route::get('/temp-manage-permissions', [App\Http\Controllers\TempPermissionController::class, 'manageUsers'])
    ->middleware('auth')
    ->name('temp.permissions.manage-users');

Route::get('/temp-edit-user-permissions/{user}', [App\Http\Controllers\TempPermissionController::class, 'editUserPermissions'])
    ->middleware('auth')
    ->name('temp.permissions.edit-user-permissions');

Route::put('/temp-update-user-permissions/{user}', [App\Http\Controllers\TempPermissionController::class, 'updateUserPermissions'])
    ->middleware('auth')
    ->name('temp.permissions.update-user-permissions');

// Profile Routes
Route::middleware(['auth'])->group(function () {
    Route::get('/profile', [App\Http\Controllers\ProfileController::class, 'edit'])->name('profile.edit');
    Route::put('/profile', [App\Http\Controllers\ProfileController::class, 'update'])->name('profile.update');
    Route::post('/profile/change-password', [App\Http\Controllers\ProfileController::class, 'changePassword'])->name('profile.change-password');
});

// Protected routes
Route::middleware(['auth'])->group(function () {
    // Companies
    Route::resource('companies', CompanyController::class);
    Route::get('companies/{id}/financial-report', [CompanyController::class, 'financialReport'])->name('companies.financial-report');

    // Company Management
    Route::resource('company_management', CompanyManagementController::class);

    // Branches
    Route::resource('branches', BranchController::class);

    // Users
    Route::resource('users', UserController::class);

    // Roles
    Route::get('roles/manage-users', [RoleController::class, 'manageUsers'])->name('roles.manage-users');
    Route::get('roles/users/{user}/edit', [RoleController::class, 'editUserRoles'])->name('roles.edit-user-roles');
    Route::put('roles/users/{user}', [RoleController::class, 'updateUserRoles'])->name('roles.update-user-roles');
    Route::resource('roles', RoleController::class);

    // Permissions
    Route::get('permissions/generate-from-controllers', [PermissionController::class, 'generateFromControllers'])->name('permissions.generate-from-controllers');
    Route::get('permissions/manage-users', [PermissionController::class, 'manageUsers'])->name('permissions.manage-users');
    Route::get('permissions/users/{user}/edit', [PermissionController::class, 'editUserPermissions'])->name('permissions.edit-user-permissions');
    Route::put('permissions/users/{user}', [PermissionController::class, 'updateUserPermissions'])->name('permissions.update-user-permissions');
    Route::resource('permissions', PermissionController::class);

    // Customers
    Route::resource('customers', CustomerController::class);
    Route::get('customers-import', [CustomerController::class, 'importForm'])->name('customers.import.form');
    Route::post('customers-import', [CustomerController::class, 'import'])->name('customers.import');
    Route::get('customers-export', [CustomerController::class, 'export'])->name('customers.export');

    // Locations
    Route::resource('locations', LocationController::class);
    Route::get('locations-import', [LocationController::class, 'importForm'])->name('locations.import.form');
    Route::post('locations-import', [LocationController::class, 'import'])->name('locations.import');
    Route::get('locations-import-template', [LocationController::class, 'downloadTemplate'])->name('locations.import.template');

    // Elevators
    Route::resource('elevators', ElevatorController::class);
    Route::get('elevators-import', [ElevatorController::class, 'importForm'])->name('elevators.import.form');
    Route::post('elevators-import', [ElevatorController::class, 'import'])->name('elevators.import');
    Route::get('elevators-import-template-excel', [ElevatorController::class, 'downloadExcelTemplate'])->name('elevators.import.template.excel');

    // Elevator Types
    Route::resource('elevator-types', ElevatorTypeController::class);

    // Elevator Models
    Route::resource('elevator-models', ElevatorModelController::class);

    // Elevator Parts
    Route::resource('elevator-parts', ElevatorPartController::class);
    Route::get('elevator-parts-low-stock', [ElevatorPartController::class, 'lowStock'])->name('elevator-parts.low-stock');
    Route::get('elevator-parts/{id}/edit-stock', [ElevatorPartController::class, 'editStock'])->name('elevator-parts.edit-stock');
    Route::put('elevator-parts/{id}/update-stock', [ElevatorPartController::class, 'updateStock'])->name('elevator-parts.update-stock');

    // Maintenance Contracts
    Route::resource('maintenance-contracts', MaintenanceContractController::class);

    // Invoices
    Route::get('invoices/recurring', [InvoiceController::class, 'recurring'])->name('invoices.recurring');
    Route::get('invoices/{id}/regenerate-qr', [InvoiceController::class, 'regenerateQrCode'])->name('invoices.regenerate-qr');
    Route::resource('invoices', InvoiceController::class);

    // Payments
    Route::get('payments/{payment}/receipt', [PaymentController::class, 'receipt'])->name('payments.receipt');
    Route::resource('payments', PaymentController::class);

    // Payment Methods
    Route::resource('payment-methods', PaymentMethodController::class);

    // Include Maintenance Routes
    require __DIR__ . '/maintenance.php';

    // Include Customer Management Routes
    require __DIR__ . '/customer_management.php';

    // Include Invoice Management Routes
    require __DIR__ . '/invoice.php';

    // Include Auto Invoice Routes
    require __DIR__ . '/auto_invoice.php';

    // Include Inventory Management Routes
    require __DIR__ . '/inventory.php';

    // Include Financial Reports Routes
    require __DIR__ . '/financial_reports.php';

    // Include Invoice Installments Routes
    require __DIR__ . '/invoice_installments.php';

    // Include Installation Projects Routes
    require __DIR__ . '/installation_projects.php';

    // Include Project Inventory Routes
    require __DIR__ . '/project_inventory.php';

    // Include Elevator Maintenance Routes
    require __DIR__ . '/elevator_maintenance.php';

    // Include Elevator Maintenance Schedules Routes
    require __DIR__ . '/elevator_maintenance_schedules.php';

    // Include Elevator Inspections Routes
    require __DIR__ . '/elevator_inspections.php';

    // Include Elevator Reports Routes
    require __DIR__ . '/elevator_reports.php';

    // Include Elevator Deliveries Routes
    require __DIR__ . '/elevator_deliveries.php';

    // Include Reports Routes
    require __DIR__ . '/reports.php';

    // Include HRM Routes
    require __DIR__ . '/web/hrm/payroll.php';
    require __DIR__ . '/web/hrm/employees.php';
    require __DIR__ . '/web/hrm/departments.php';
    require __DIR__ . '/web/hrm/attendance.php';
    require __DIR__ . '/web/hrm/leaves.php';
    require __DIR__ . '/web/hrm/salaries.php';
    require __DIR__ . '/web/hrm/bonuses.php';
    require __DIR__ . '/web/hrm/loans.php';
    require __DIR__ . '/web/hrm/evaluations.php';
    require __DIR__ . '/web/hrm/salary_policies.php';
    require __DIR__ . '/hrm_training.php';
    require __DIR__ . '/hrm_tasks.php';

    // Notifications
    Route::get('notifications', [NotificationController::class, 'index'])->name('notifications.index')->middleware('permission:view_maintenance_notifications');
    Route::get('notifications/{notification}', [NotificationController::class, 'show'])->name('notifications.show')->middleware('permission:view_maintenance_notifications');
    Route::get('notifications/{notification}/mark-read', [NotificationController::class, 'markAsRead'])->name('notifications.mark-read')->middleware('permission:view_maintenance_notifications');

    // Include Advanced Notifications Routes
    require __DIR__ . '/advanced-notifications.php';
    Route::get('notifications-mark-all-read', [NotificationController::class, 'markAllAsRead'])->name('notifications.mark-all-read')->middleware('permission:view_maintenance_notifications');
    Route::delete('notifications/{notification}', [NotificationController::class, 'destroy'])->name('notifications.destroy')->middleware('permission:delete_maintenance_notifications');
    Route::get('notifications-unread-count', [NotificationController::class, 'getUnreadCount'])->name('notifications.unread-count')->middleware('permission:view_maintenance_notifications');
    Route::get('notifications-recent-unread', [NotificationController::class, 'getRecentUnread'])->name('notifications.recent-unread')->middleware('permission:view_maintenance_notifications');

    // Include Cash Registers Routes
    require __DIR__ . '/cash_registers.php';

    // Include Accounting Routes
    require __DIR__ . '/accounting.php';

    // Include Banking System Routes
    require __DIR__ . '/banking.php';

    // Include Company Settings Routes
    require __DIR__ . '/company_settings.php';

    // Include Work Orders Routes
    require __DIR__ . '/work_orders.php';

    // Include Inventory Issues Routes
    require __DIR__ . '/inventory_issues.php';

    // Include Inventory Units Routes
    require __DIR__ . '/inventory_units.php';

    // Include ZATCA E-Invoicing Routes
    require __DIR__ . '/zatca.php';

    // Include Arabic Users Routes
    require __DIR__ . '/arabic-users.php';

    // Include Civil Defense Routes
    require __DIR__ . '/civil_defense.php';
});

// Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
