<?php

use App\Http\Controllers\TaxSettingController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| إعدادات الضرائب Routes
|--------------------------------------------------------------------------
|
| هنا يتم تعريف مسارات إعدادات الضرائب
|
*/

Route::middleware(['auth'])->group(function () {
    // مسارات إعدادات الضرائب
    Route::get('/tax-settings', [TaxSettingController::class, 'index'])->name('tax_settings.index');
    Route::get('/tax-settings/create', [TaxSettingController::class, 'create'])->name('tax_settings.create');
    Route::post('/tax-settings', [TaxSettingController::class, 'store'])->name('tax_settings.store');
    Route::get('/tax-settings/{taxSetting}/edit', [TaxSettingController::class, 'edit'])->name('tax_settings.edit');
    Route::put('/tax-settings/{taxSetting}', [TaxSettingController::class, 'update'])->name('tax_settings.update');
    Route::delete('/tax-settings/{taxSetting}', [TaxSettingController::class, 'destroy'])->name('tax_settings.destroy');
    Route::put('/tax-settings/{taxSetting}/set-default', [TaxSettingController::class, 'setDefault'])->name('tax_settings.set_default');
});
