<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SalesReturnController;

Route::middleware(['auth'])->group(function () {
    // مسارات مرتجع المبيعات
    Route::get('sales-returns', [SalesReturnController::class, 'index'])->name('sales-returns.index');
    Route::get('sales-returns/create', [SalesReturnController::class, 'create'])->name('sales-returns.create');
    Route::post('sales-returns', [SalesReturnController::class, 'store'])->name('sales-returns.store');
    Route::get('sales-returns/{salesReturn}', [SalesReturnController::class, 'show'])->name('sales-returns.show');
    Route::get('sales-returns/{salesReturn}/edit', [SalesReturnController::class, 'edit'])->name('sales-returns.edit');
    Route::put('sales-returns/{salesReturn}', [SalesReturnController::class, 'update'])->name('sales-returns.update');
    Route::delete('sales-returns/{salesReturn}', [SalesReturnController::class, 'destroy'])->name('sales-returns.destroy');

    // مسارات إضافية لمرتجع المبيعات
    Route::post('sales-returns/{salesReturn}/approve', [SalesReturnController::class, 'approve'])->name('sales-returns.approve');
    Route::post('sales-returns/{salesReturn}/cancel', [SalesReturnController::class, 'cancel'])->name('sales-returns.cancel');
    Route::post('sales-returns/get-invoice-items', [SalesReturnController::class, 'getInvoiceItems'])->name('sales-returns.get-invoice-items');
});
