<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ReportController;

/*
|--------------------------------------------------------------------------
| Reports Routes
|--------------------------------------------------------------------------
|
| Here is where you can register reports related routes for your application.
|
*/

// تقارير النظام
Route::prefix('reports')->name('reports.')->middleware(['auth', 'verified'])->group(function () {
    // الصفحة الرئيسية للتقارير
    Route::get('/', [ReportController::class, 'index'])->name('index');

    // تقارير المبيعات
    Route::get('/sales', [ReportController::class, 'sales'])->name('sales');

    // تقارير الصيانة
    Route::get('/maintenance', [ReportController::class, 'maintenance'])->name('maintenance');

    // تقارير المخزون
    Route::get('/inventory', [ReportController::class, 'inventory'])->name('inventory');

    // التقارير المالية
    Route::get('/financial', [ReportController::class, 'financial'])->name('financial');
});
