<?php

use App\Http\Controllers\ProjectInventoryRequestController;
use Illuminate\Support\Facades\Route;

// مسارات طلبات المخزون للمشاريع
Route::middleware(['auth'])->group(function () {
    // قائمة طلبات المخزون للمشروع
    Route::get('/projects/{project}/inventory', [ProjectInventoryRequestController::class, 'index'])
        ->name('projects.inventory.index');

    // إنشاء طلب مخزون جديد
    Route::get('/projects/{project}/inventory/create', [ProjectInventoryRequestController::class, 'create'])
        ->name('projects.inventory.create');
    Route::post('/projects/{project}/inventory', [ProjectInventoryRequestController::class, 'store'])
        ->name('projects.inventory.store');

    // عرض تفاصيل طلب مخزون
    Route::get('/projects/{project}/inventory/{request}', [ProjectInventoryRequestController::class, 'show'])
        ->name('projects.inventory.show');

    // تعديل طلب مخزون
    Route::get('/projects/{project}/inventory/{request}/edit', [ProjectInventoryRequestController::class, 'edit'])
        ->name('projects.inventory.edit');
    Route::put('/projects/{project}/inventory/{request}', [ProjectInventoryRequestController::class, 'update'])
        ->name('projects.inventory.update');

    // حذف طلب مخزون
    Route::delete('/projects/{project}/inventory/{request}', [ProjectInventoryRequestController::class, 'destroy'])
        ->name('projects.inventory.destroy');

    // اعتماد طلب مخزون
    Route::post('/projects/{project}/inventory/{request}/approve', [ProjectInventoryRequestController::class, 'approve'])
        ->name('projects.inventory.approve');

    // رفض طلب مخزون
    Route::post('/projects/{project}/inventory/{request}/reject', [ProjectInventoryRequestController::class, 'reject'])
        ->name('projects.inventory.reject');

    // تنفيذ طلب مخزون
    Route::post('/projects/{project}/inventory/{request}/fulfill', [ProjectInventoryRequestController::class, 'fulfill'])
        ->name('projects.inventory.fulfill');

    // التحقق من توفر المخزون
    Route::get('/inventory/check-availability', [ProjectInventoryRequestController::class, 'checkAvailability'])
        ->name('inventory.check-availability');
});
