<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MaintenanceFinancialController;
use App\Http\Controllers\MaintenanceNotificationsController;

/*
|--------------------------------------------------------------------------
| Maintenance Financial Routes
|--------------------------------------------------------------------------
|
| هنا يتم تعريف مسارات التقارير المالية للصيانة وإشعارات الصيانة
|
*/

// مسارات التقارير المالية للصيانة
Route::middleware(['auth', 'verified'])->group(function () {
    // التقارير المالية
    Route::get('/maintenance-financial/reports', [MaintenanceFinancialController::class, 'showReports'])
        ->name('maintenance-financial.reports')
        ->middleware('permission:view_maintenance_financial_reports');

    // معالجة التقارير المالية
    Route::post('/maintenance-financial/reports', [MaintenanceFinancialController::class, 'processReports'])
        ->name('maintenance-financial.process-reports')
        ->middleware('permission:view_maintenance_financial_reports');

    // تقارير أداء الفنيين
    Route::get('/maintenance-financial/technician-performance', [MaintenanceFinancialController::class, 'showTechnicianPerformance'])
        ->name('maintenance-financial.technician-performance')
        ->middleware('permission:view_maintenance_financial_reports');

    // معالجة تقارير أداء الفنيين
    Route::post('/maintenance-financial/technician-performance', [MaintenanceFinancialController::class, 'processTechnicianPerformance'])
        ->name('maintenance-financial.process-technician-performance')
        ->middleware('permission:view_maintenance_financial_reports');

    // إنشاء فواتير الصيانة
    Route::get('/maintenance-financial/generate-invoices', [MaintenanceFinancialController::class, 'showGenerateInvoices'])
        ->name('maintenance-financial.generate-invoices')
        ->middleware('permission:create_maintenance_invoices');

    // معالجة إنشاء فواتير الصيانة
    Route::post('/maintenance-financial/generate-invoices', [MaintenanceFinancialController::class, 'processGenerateInvoices'])
        ->name('maintenance-financial.process-generate-invoices')
        ->middleware('permission:create_maintenance_invoices');

    // تصدير التقارير المالية
    Route::get('/maintenance-financial/export-reports', [MaintenanceFinancialController::class, 'exportReports'])
        ->name('maintenance-financial.export-reports')
        ->middleware('permission:export_maintenance_financial_reports');
});

// مسارات إشعارات الصيانة
Route::middleware(['auth', 'verified'])->group(function () {
    // قائمة إشعارات الصيانة
    Route::get('/maintenance-notifications', [MaintenanceNotificationsController::class, 'index'])
        ->name('maintenance-notifications.index')
        ->middleware('permission:view_maintenance_notifications');

    // عرض تفاصيل إشعار الصيانة
    Route::get('/maintenance-notifications/{notification}', [MaintenanceNotificationsController::class, 'show'])
        ->name('maintenance-notifications.show')
        ->middleware('permission:view_maintenance_notifications');

    // تحديث حالة إشعار الصيانة
    Route::put('/maintenance-notifications/{notification}/status', [MaintenanceNotificationsController::class, 'updateStatus'])
        ->name('maintenance-notifications.update-status')
        ->middleware('permission:edit_maintenance_notifications');

    // إنشاء إشعارات الصيانة
    Route::post('/maintenance-notifications/send-pending', [MaintenanceNotificationsController::class, 'sendPending'])
        ->name('maintenance-notifications.send-pending')
        ->middleware('permission:create_maintenance_notifications');

    // حذف إشعار الصيانة
    Route::delete('/maintenance-notifications/{notification}', [MaintenanceNotificationsController::class, 'destroy'])
        ->name('maintenance-notifications.destroy')
        ->middleware('permission:delete_maintenance_notifications');
});
