<?php

use App\Http\Controllers\MaintenanceScheduleController;
use App\Http\Controllers\MaintenanceLogController;
use App\Http\Controllers\MaintenanceRequestController;
use App\Http\Controllers\MaintenanceTeamController;
use App\Http\Controllers\MaintenanceCalendarController;
use App\Http\Controllers\MaintenanceInvoiceController;
use App\Http\Controllers\MaintenanceReportController;
use Illuminate\Support\Facades\Route;

// Maintenance Requests Routes
Route::resource('maintenance-requests', MaintenanceRequestController::class);

// Maintenance Schedules Routes
Route::get('maintenance-schedules/calendar', [MaintenanceScheduleController::class, 'calendar'])->name('maintenance-schedules.calendar');
Route::post('maintenance-schedules/generate', [MaintenanceScheduleController::class, 'generateSchedules'])->name('maintenance-schedules.generate');
Route::resource('maintenance-schedules', MaintenanceScheduleController::class);

// Maintenance Logs Routes
Route::resource('maintenance-logs', MaintenanceLogController::class);
Route::get('maintenance/elevator/{elevator}/history', [MaintenanceLogController::class, 'elevatorHistory'])->name('maintenance.elevator.history');
Route::get('maintenance-logs-export', [MaintenanceLogController::class, 'export'])->name('maintenance-logs.export');
Route::get('maintenance-logs/by-customer', [MaintenanceLogController::class, 'byCustomer'])->name('maintenance-logs.by-customer');

// Maintenance Teams Routes
Route::resource('maintenance-teams', MaintenanceTeamController::class);

// Maintenance Calendar Routes
Route::get('maintenance-calendar/events', [MaintenanceCalendarController::class, 'getEvents'])->name('maintenance-calendar.events');
Route::resource('maintenance-calendar', MaintenanceCalendarController::class);

// Maintenance Invoices Routes
Route::resource('maintenance-invoices', MaintenanceInvoiceController::class);
Route::get('maintenance-invoices/{maintenanceInvoice}/print', [MaintenanceInvoiceController::class, 'print'])->name('maintenance-invoices.print');
Route::get('maintenance-invoices/{maintenanceInvoice}/send', [MaintenanceInvoiceController::class, 'send'])->name('maintenance-invoices.send');
Route::get('maintenance-invoices/{maintenanceInvoice}/mark-as-paid', [MaintenanceInvoiceController::class, 'markAsPaid'])->name('maintenance-invoices.mark-as-paid');
Route::get('maintenance-invoices/{maintenanceInvoice}/mark-as-cancelled', [MaintenanceInvoiceController::class, 'markAsCancelled'])->name('maintenance-invoices.mark-as-cancelled');

// Maintenance Reports Routes
Route::resource('maintenance-reports', MaintenanceReportController::class);
Route::get('maintenance-reports/performance', [MaintenanceReportController::class, 'performanceReport'])->name('maintenance-reports.performance');
Route::get('maintenance-reports/elevator-status', [MaintenanceReportController::class, 'elevatorStatusReport'])->name('maintenance-reports.elevator-status');
Route::get('maintenance-reports/cost', [MaintenanceReportController::class, 'costReport'])->name('maintenance-reports.cost');
Route::get('maintenance-reports/schedule-compliance', [MaintenanceReportController::class, 'scheduleComplianceReport'])->name('maintenance-reports.schedule-compliance');
Route::get('maintenance-reports/issues', [MaintenanceReportController::class, 'issuesReport'])->name('maintenance-reports.issues');

// API Routes for Maintenance
Route::prefix('api')->middleware(['auth'])->group(function () {
    Route::get('maintenance-schedules/monthly', [\App\Http\Controllers\API\MaintenanceScheduleController::class, 'getMonthlySchedule']);
    Route::get('maintenance-schedules/{schedule}', [\App\Http\Controllers\API\MaintenanceScheduleController::class, 'show']);

    Route::get('contracts/{contract}/elevators', function ($contract) {
        $contract = \App\Models\MaintenanceContract::findOrFail($contract);
        return $contract->elevators;
    });

    Route::get('contracts/{contract}', function ($contract) {
        return \App\Models\MaintenanceContract::findOrFail($contract);
    });
});
