<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\InvoiceInstallmentController;

Route::middleware(['auth'])->group(function () {
    // لوحة معلومات الأقساط
    Route::get('/invoice-installments/dashboard', [InvoiceInstallmentController::class, 'dashboard'])
        ->name('invoice-installments.dashboard');

    // تسجيل دفعة لقسط
    Route::post('/invoice-installments/{id}/record-payment', [InvoiceInstallmentController::class, 'recordPayment'])
        ->name('invoice-installments.record-payment');

    // إرسال تذكير بالقسط
    Route::post('/invoice-installments/{id}/send-reminder', [InvoiceInstallmentController::class, 'sendReminder'])
        ->name('invoice-installments.send-reminder');

    // تقرير الأقساط المتأخرة
    Route::get('/invoice-installments/reports/overdue', [InvoiceInstallmentController::class, 'overdueReport'])
        ->name('invoice-installments.overdue-report');

    // تقرير الأقساط المستحقة قريباً
    Route::get('/invoice-installments/reports/upcoming', [InvoiceInstallmentController::class, 'upcomingReport'])
        ->name('invoice-installments.upcoming-report');

    // تحديث حالة الأقساط المتأخرة يدوياً
    Route::post('/invoice-installments/update-overdue', [InvoiceInstallmentController::class, 'updateOverdue'])
        ->name('invoice-installments.update-overdue');

    // صفحة تسجيل دفعات الأقساط
    Route::get('/invoice-installments/payments/index', [InvoiceInstallmentController::class, 'payments'])
        ->name('invoice-installments.payments');

    // صفحة تقارير الأقساط
    Route::get('/invoice-installments/reports/index', [InvoiceInstallmentController::class, 'reports'])
        ->name('invoice-installments.reports');

    // صفحة إرسال تذكيرات الأقساط
    Route::get('/invoice-installments/send-reminders/index', [InvoiceInstallmentController::class, 'sendReminders'])
        ->name('invoice-installments.send-reminders');

    // إرسال تذكيرات للأقساط المستحقة قريباً
    Route::post('/invoice-installments/send-upcoming-reminders', [InvoiceInstallmentController::class, 'sendUpcomingReminders'])
        ->name('invoice-installments.send-upcoming-reminders');

    // إرسال تذكيرات للأقساط المتأخرة
    Route::post('/invoice-installments/send-overdue-reminders', [InvoiceInstallmentController::class, 'sendOverdueReminders'])
        ->name('invoice-installments.send-overdue-reminders');

    // إرسال تذكيرات للأقساط المستحقة قريباً
    Route::post('/invoice-installments/send-upcoming-reminders', [InvoiceInstallmentController::class, 'sendUpcomingReminders'])
        ->name('invoice-installments.send-upcoming-reminders');

    // إرسال تذكير لقسط محدد
    Route::post('/invoice-installments/{installment}/send-reminder', [InvoiceInstallmentController::class, 'sendReminder'])
        ->name('invoice-installments.send-reminder');

    // تقرير الأقساط المتأخرة
    Route::get('/invoice-installments/reports/overdue', [InvoiceInstallmentController::class, 'overdueReport'])
        ->name('invoice-installments.overdue-report');

    // تقرير الأقساط المستحقة قريباً
    Route::get('/invoice-installments/reports/upcoming', [InvoiceInstallmentController::class, 'upcomingReport'])
        ->name('invoice-installments.upcoming-report');

    // تصدير تقرير الأقساط المتأخرة
    Route::get('/invoice-installments/reports/overdue/export', [InvoiceInstallmentController::class, 'exportOverdueReport'])
        ->name('invoice-installments.export-overdue');

    // تصدير تقرير الأقساط المستحقة قريباً
    Route::get('/invoice-installments/reports/upcoming/export', [InvoiceInstallmentController::class, 'exportUpcomingReport'])
        ->name('invoice-installments.export-upcoming');

    // صفحة تقارير الأقساط الرئيسية
    Route::get('/invoice-installments/reports', [InvoiceInstallmentController::class, 'reports'])
        ->name('invoice-installments.reports');

    // مسارات CRUD الأساسية
    Route::resource('invoice-installments', InvoiceInstallmentController::class);
});
