<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\InvoiceTemplateController;
use App\Http\Controllers\InvoiceInstallmentController;
use App\Http\Controllers\TaxReportController;
use App\Http\Controllers\FinancialReportController;
use App\Http\Controllers\CustomerStatementController;

/*
|--------------------------------------------------------------------------
| Invoice Routes
|--------------------------------------------------------------------------
|
| Here is where you can register invoice related routes for your application.
|
*/

// الفواتير
// Route::get('invoices/recurring', [InvoiceController::class, 'recurring'])->name('invoices.recurring');
Route::post('invoices/generate-from-contract/{contract}', [InvoiceController::class, 'generateFromContract'])->name('invoices.generate-from-contract');
Route::post('invoices/generate-recurring', [InvoiceController::class, 'generateRecurringInvoices'])->name('invoices.generate-recurring');
Route::post('invoices/update-statuses', [InvoiceController::class, 'updateInvoiceStatuses'])->name('invoices.update-statuses');
Route::get('invoices/{invoice}/export-pdf', [InvoiceController::class, 'exportPdf'])->name('invoices.export-pdf');
Route::get('invoices/{invoice}/export-excel', [InvoiceController::class, 'exportExcel'])->name('invoices.export-excel');
Route::get('invoices/{invoice}/preview-html', [InvoiceController::class, 'previewHtml'])->name('invoices.preview-html');
Route::get('invoices/{invoice}/download-pdf', [InvoiceController::class, 'downloadPdf'])->name('invoices.download-pdf');
Route::get('invoices/{invoice}/print', [InvoiceController::class, 'print'])->name('invoices.print');
Route::post('invoices/{invoice}/change-template', [InvoiceController::class, 'changeTemplate'])->name('invoices.change-template');
Route::post('invoices/{invoice}/make-recurring', [InvoiceController::class, 'makeRecurring'])->name('invoices.make-recurring');
Route::post('invoices/{invoice}/create-installments', [InvoiceController::class, 'createInstallments'])->name('invoices.create-installments');

// قوالب الفواتير
Route::get('invoice-templates/{template}/preview', [InvoiceTemplateController::class, 'preview'])->name('invoice-templates.preview');
Route::resource('invoice-templates', InvoiceTemplateController::class);

// أقساط الفواتير
Route::resource('invoice-installments', InvoiceInstallmentController::class);

// تقارير الضرائب
Route::get('tax-reports/generate', [TaxReportController::class, 'generateForm'])->name('tax-reports.generate-form');
Route::post('tax-reports/generate', [TaxReportController::class, 'generate'])->name('tax-reports.generate');
Route::get('tax-reports/{report}/export', [TaxReportController::class, 'export'])->name('tax-reports.export');
Route::resource('tax-reports', TaxReportController::class);

// التقارير المالية
Route::get('financial-reports', [FinancialReportController::class, 'index'])->name('financial-reports.index');
Route::get('financial-reports/income-expense', [FinancialReportController::class, 'incomeExpenseForm'])->name('financial-reports.income-expense-form');
Route::post('financial-reports/income-expense', [FinancialReportController::class, 'incomeExpense'])->name('financial-reports.income-expense');
Route::get('financial-reports/profitability', [FinancialReportController::class, 'profitabilityForm'])->name('financial-reports.profitability-form');
Route::post('financial-reports/profitability', [FinancialReportController::class, 'profitability'])->name('financial-reports.profitability');
Route::get('financial-reports/export/{type}', [FinancialReportController::class, 'export'])->name('financial-reports.export');

// كشوف حساب العملاء
Route::get('customer-statements', [CustomerStatementController::class, 'index'])->name('customer-statements.index');
Route::get('customer-statements/generate', [CustomerStatementController::class, 'generateForm'])->name('customer-statements.generate-form');
Route::post('customer-statements/generate', [CustomerStatementController::class, 'generate'])->name('customer-statements.generate');
Route::get('customer-statements/{customer}/export', [CustomerStatementController::class, 'export'])->name('customer-statements.export');
