<?php

use App\Http\Controllers\InventoryUnitController;
use App\Http\Controllers\InventoryItemUnitController;
use Illuminate\Support\Facades\Route;

// مسارات الوحدات
Route::middleware(['auth', 'verified'])->group(function () {
    // مسارات إدارة الوحدات
    Route::prefix('inventory/units')->name('inventory.units.')->group(function () {
        Route::get('/', [InventoryUnitController::class, 'index'])->name('index')->middleware('permission:view_inventory|user3');
        Route::get('/create', [InventoryUnitController::class, 'create'])->name('create')->middleware('permission:create_inventory');
        Route::post('/', [InventoryUnitController::class, 'store'])->name('store')->middleware('permission:create_inventory');
        Route::get('/{id}', [InventoryUnitController::class, 'show'])->name('show')->middleware('permission:view_inventory|user3');
        Route::get('/{id}/edit', [InventoryUnitController::class, 'edit'])->name('edit')->middleware('permission:edit_inventory');
        Route::put('/{id}', [InventoryUnitController::class, 'update'])->name('update')->middleware('permission:edit_inventory');
        Route::delete('/{id}', [InventoryUnitController::class, 'destroy'])->name('destroy')->middleware('permission:delete_inventory');
    });

    // مسارات إدارة وحدات الأصناف
    Route::prefix('inventory/items/{itemId}/units')->name('inventory.items.units.')->group(function () {
        Route::get('/', [InventoryItemUnitController::class, 'index'])->name('index')->middleware('permission:view_inventory|user3');
        Route::get('/create', [InventoryItemUnitController::class, 'create'])->name('create')->middleware('permission:create_inventory');
        Route::post('/', [InventoryItemUnitController::class, 'store'])->name('store')->middleware('permission:create_inventory');
        Route::get('/{id}/edit', [InventoryItemUnitController::class, 'edit'])->name('edit')->middleware('permission:edit_inventory');
        Route::put('/{id}', [InventoryItemUnitController::class, 'update'])->name('update')->middleware('permission:edit_inventory');
        Route::delete('/{id}', [InventoryItemUnitController::class, 'destroy'])->name('destroy')->middleware('permission:delete_inventory');
    });

    // مسار مختصر لوحدات الأصناف (للتوافق مع الروابط القديمة)
    Route::prefix('inventory/item-units')->name('inventory.item-units.')->group(function () {
        Route::get('/', [InventoryItemUnitController::class, 'indexAll'])->name('index')->middleware('permission:view_inventory|user3');
        Route::get('/create/{itemId}', [InventoryItemUnitController::class, 'create'])->name('create')->middleware('permission:create_inventory');
    });

    // مسار إضافي للحفظ (لتوافق مع نموذج الإنشاء)
    Route::post('inventory/item-units/store/{itemId}', [InventoryItemUnitController::class, 'store'])->name('inventory.item-units.store')->middleware('permission:create_inventory');
});
