<?php

use App\Http\Controllers\InventoryIssueController;
use Illuminate\Support\Facades\Route;

// مسارات إذن صرف المخازن
Route::middleware(['auth'])->group(function () {
    Route::get('inventory-issues', [InventoryIssueController::class, 'index'])->name('inventory-issues.index');
    Route::get('inventory-issues/create', [InventoryIssueController::class, 'create'])->name('inventory-issues.create');
    Route::post('inventory-issues', [InventoryIssueController::class, 'store'])->name('inventory-issues.store');

    // مسار الحصول على معلومات أمر الشغل (يجب أن يكون قبل المسارات التي تحتوي على معرفات)
    Route::get('inventory-issues/work-order-info', [InventoryIssueController::class, 'getWorkOrderInfo'])->name('inventory-issues.get-work-order-info');

    // مسار بديل للحصول على معلومات أمر الشغل (للتأكد من أن المشكلة ليست في المسار)
    Route::get('api/work-order-info', [InventoryIssueController::class, 'getWorkOrderInfo'])->name('api.work-order-info');

    Route::get('inventory-issues/{inventoryIssue}', [InventoryIssueController::class, 'show'])->name('inventory-issues.show');
    Route::get('inventory-issues/{inventoryIssue}/edit', [InventoryIssueController::class, 'edit'])->name('inventory-issues.edit');
    Route::put('inventory-issues/{inventoryIssue}', [InventoryIssueController::class, 'update'])->name('inventory-issues.update');
    Route::delete('inventory-issues/{inventoryIssue}', [InventoryIssueController::class, 'destroy'])->name('inventory-issues.destroy');
    Route::patch('inventory-issues/{inventoryIssue}/complete', [InventoryIssueController::class, 'complete'])->name('inventory-issues.complete');
});
