<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WarehouseController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\InventoryCategoryController;
use App\Http\Controllers\InventoryItemController;
use App\Http\Controllers\InventoryStockController;
use App\Http\Controllers\InventoryBatchController;
use App\Http\Controllers\InventorySerialController;
use App\Http\Controllers\PurchaseOrderController;
use App\Http\Controllers\InventoryTransactionController;
use App\Http\Controllers\SupplierEvaluationController;
use App\Http\Controllers\InventoryDashboardController;
use App\Http\Controllers\InventoryCountController;
use App\Http\Controllers\InventoryAlertController;
use App\Http\Controllers\Inventory\AutoPurchaseController;
use App\Http\Controllers\Inventory\AutoPurchaseRunController;
use App\Http\Controllers\Inventory\AutoPurchaseAnalyticsController;
use App\Http\Controllers\Inventory\BarcodeController;
use App\Http\Controllers\Inventory\AdvancedBarcodeController;
use App\Http\Controllers\Inventory\InventoryValuationController;
use App\Http\Controllers\PurchaseInvoiceController;
use App\Http\Controllers\PurchaseInvoicePaymentController;
use App\Http\Controllers\PurchaseReturnController;
use App\Http\Controllers\InventoryItemMovementController;

/*
|--------------------------------------------------------------------------
| Inventory Management Routes
|--------------------------------------------------------------------------
|
| Here is where you can register inventory management related routes for your application.
|
*/

Route::middleware(['auth', 'verified'])->prefix('inventory')->name('inventory.')->group(function () {
    // Dashboard
    Route::get('/', [InventoryDashboardController::class, 'index'])->name('dashboard');

    // Auto Purchase Rules
    Route::get('auto-purchase', [AutoPurchaseController::class, 'index'])->name('auto-purchase.index');
    Route::get('auto-purchase/create', [AutoPurchaseController::class, 'create'])->name('auto-purchase.create');
    Route::post('auto-purchase', [AutoPurchaseController::class, 'store'])->name('auto-purchase.store');
    Route::get('auto-purchase/run-check', [AutoPurchaseRunController::class, 'runCheck'])->name('auto-purchase.run-check');
    Route::get('auto-purchase/{id}', [AutoPurchaseController::class, 'show'])->name('auto-purchase.show');
    Route::get('auto-purchase/{id}/edit', [AutoPurchaseController::class, 'edit'])->name('auto-purchase.edit');
    Route::put('auto-purchase/{id}', [AutoPurchaseController::class, 'update'])->name('auto-purchase.update');
    Route::delete('auto-purchase/{id}', [AutoPurchaseController::class, 'destroy'])->name('auto-purchase.destroy');

    // Auto Purchase Analytics
    Route::get('auto-purchase/analytics/index', [AutoPurchaseAnalyticsController::class, 'index'])->name('auto-purchase.analytics');
    Route::get('auto-purchase/analytics/forecast', [AutoPurchaseAnalyticsController::class, 'forecast'])->name('auto-purchase.forecast');
    Route::get('auto-purchase/analytics/performance', [AutoPurchaseAnalyticsController::class, 'performance'])->name('auto-purchase.performance');
    Route::get('auto-purchase/analytics/recommendations', [AutoPurchaseAnalyticsController::class, 'recommendations'])->name('auto-purchase.recommendations');
    Route::get('auto-purchase/analytics/smart-recommendations', [AutoPurchaseAnalyticsController::class, 'smartRecommendations'])->name('auto-purchase.smart-recommendations');
    Route::post('auto-purchase/analytics/apply-recommendation/{id}', [AutoPurchaseAnalyticsController::class, 'applyRecommendation'])->name('auto-purchase.apply-recommendation');
    Route::post('auto-purchase/analytics/create-recommended-rule', [AutoPurchaseAnalyticsController::class, 'createRecommendedRule'])->name('auto-purchase.create-recommended-rule');
    Route::post('auto-purchase/analytics/adjust-seasonal/{id}', [AutoPurchaseAnalyticsController::class, 'adjustSeasonal'])->name('auto-purchase.adjust-seasonal');

    // Warehouses
    Route::resource('warehouses', WarehouseController::class);

    // Suppliers
    Route::resource('suppliers', SupplierController::class);

    // Supplier Evaluations
    Route::resource('supplier-evaluations', SupplierEvaluationController::class);

    // Inventory Categories
    Route::resource('categories', InventoryCategoryController::class);

    // Inventory Items
    Route::get('items/low-stock', [InventoryItemController::class, 'lowStock'])->name('items.low-stock');
    Route::get('items/{id}/qrcode', [InventoryItemController::class, 'qrcode'])->name('items.qrcode');
    Route::resource('items', InventoryItemController::class);

    // Inventory Stock
    Route::get('stock', [InventoryStockController::class, 'index'])->name('stock.index');
    Route::get('stock/adjust', [InventoryStockController::class, 'adjustForm'])->name('stock.adjust-form');
    Route::post('stock/adjust', [InventoryStockController::class, 'adjust'])->name('stock.adjust');
    Route::get('stock/transfer', [InventoryStockController::class, 'transferForm'])->name('stock.transfer-form');
    Route::post('stock/transfer', [InventoryStockController::class, 'transfer'])->name('stock.transfer');

    // Inventory Batches
    Route::resource('batches', InventoryBatchController::class);

    // Inventory Serials
    Route::get('serials/{id}/qrcode', [InventorySerialController::class, 'qrcode'])->name('serials.qrcode');
    Route::resource('serials', InventorySerialController::class);

    // Purchase Orders
    Route::get('purchase-orders/{id}/receive', [PurchaseOrderController::class, 'receiveForm'])->name('purchase-orders.receive-form');
    Route::post('purchase-orders/{id}/receive', [PurchaseOrderController::class, 'receive'])->name('purchase-orders.receive');
    Route::get('purchase-orders/{id}/print', [PurchaseOrderController::class, 'print'])->name('purchase-orders.print');
    Route::post('purchase-orders/{id}/approve', [PurchaseOrderController::class, 'approve'])->name('purchase-orders.approve');
    Route::post('purchase-orders/{id}/cancel', [PurchaseOrderController::class, 'cancel'])->name('purchase-orders.cancel');
    Route::resource('purchase-orders', PurchaseOrderController::class);

    // Inventory Transactions
    Route::get('transactions', [InventoryTransactionController::class, 'index'])->name('transactions.index');
    Route::get('transactions/{id}', [InventoryTransactionController::class, 'show'])->name('transactions.show');

    // Barcode Management
    Route::get('barcodes', [BarcodeController::class, 'index'])->name('barcodes.index');
    Route::get('barcodes/generate/{id}', [BarcodeController::class, 'generateItemBarcode'])->name('barcodes.generate');
    Route::post('barcodes/generate/{id}', [BarcodeController::class, 'storeItemBarcode'])->name('barcodes.store');
    Route::get('barcodes/scan', [BarcodeController::class, 'scanBarcode'])->name('barcodes.scan');
    Route::post('barcodes/scan/process', [BarcodeController::class, 'processScan'])->name('barcodes.process-scan');
    Route::post('barcodes/transaction', [BarcodeController::class, 'createTransaction'])->name('barcodes.create-transaction');
    Route::get('barcodes/print-multiple', [BarcodeController::class, 'printMultiple'])->name('barcodes.print-multiple');
    Route::post('barcodes/print-multiple', [BarcodeController::class, 'processPrintMultiple'])->name('barcodes.process-print-multiple');

    // Advanced Barcode Management
    Route::get('barcodes/advanced', [AdvancedBarcodeController::class, 'index'])->name('barcodes.advanced');
    Route::post('barcodes/generate-custom', [AdvancedBarcodeController::class, 'generateCustom'])->name('barcodes.generate-custom');
    Route::get('barcodes/generate-item', [AdvancedBarcodeController::class, 'generateItemBarcode'])->name('barcodes.generate-item');
    Route::post('barcodes/print-multiple', [AdvancedBarcodeController::class, 'printMultiple'])->name('barcodes.print-multiple');
    Route::post('barcodes/save-template', [AdvancedBarcodeController::class, 'saveTemplate'])->name('barcodes.save-template');
    Route::get('barcodes/edit-template/{id}', [AdvancedBarcodeController::class, 'editTemplate'])->name('barcodes.edit-template');
    Route::put('barcodes/update-template/{id}', [AdvancedBarcodeController::class, 'updateTemplate'])->name('barcodes.update-template');
    Route::delete('barcodes/delete-template/{id}', [AdvancedBarcodeController::class, 'deleteTemplate'])->name('barcodes.delete-template');
    Route::post('barcodes/process-scan', [AdvancedBarcodeController::class, 'processScan'])->name('barcodes.process-scan');

    // Inventory Valuation
    Route::get('valuation', [InventoryValuationController::class, 'index'])->name('valuation.index');
    Route::post('valuation/report', [InventoryValuationController::class, 'report'])->name('valuation.report');
    Route::get('valuation/history', [InventoryValuationController::class, 'history'])->name('valuation.history');
    Route::post('valuation/store', [InventoryValuationController::class, 'store'])->name('valuation.store');
    Route::post('valuation/calculate-average', [InventoryValuationController::class, 'calculateAverage'])->name('valuation.calculate-average');

    // Inventory Counts
    Route::get('counts', [InventoryCountController::class, 'index'])->name('counts.index');
    Route::get('counts/create', [InventoryCountController::class, 'create'])->name('counts.create');
    Route::post('counts', [InventoryCountController::class, 'store'])->name('counts.store');
    Route::get('counts/{id}', [InventoryCountController::class, 'show'])->name('counts.show');
    Route::get('counts/{id}/count', [InventoryCountController::class, 'count'])->name('counts.count');
    Route::post('counts/{id}/item/{itemId}', [InventoryCountController::class, 'updateItem'])->name('counts.update-item');
    Route::post('counts/{id}/complete', [InventoryCountController::class, 'complete'])->name('counts.complete');
    Route::post('counts/{id}/approve', [InventoryCountController::class, 'approve'])->name('counts.approve');
    Route::post('counts/{id}/cancel', [InventoryCountController::class, 'cancel'])->name('counts.cancel');
    Route::get('counts/{id}/print', [InventoryCountController::class, 'print'])->name('counts.print');

    // Inventory Alerts
    Route::get('alerts/settings', [InventoryAlertController::class, 'settings'])->name('alerts.settings');
    Route::post('alerts/settings', [InventoryAlertController::class, 'updateSettings'])->name('alerts.update-settings');
    Route::get('alerts/low-stock', [InventoryAlertController::class, 'lowStock'])->name('alerts.low-stock');
    Route::get('alerts/expiry', [InventoryAlertController::class, 'expiry'])->name('alerts.expiry');
    Route::post('alerts/send-low-stock', [InventoryAlertController::class, 'sendLowStockAlerts'])->name('alerts.send-low-stock');
    Route::post('alerts/send-expiry', [InventoryAlertController::class, 'sendExpiryAlerts'])->name('alerts.send-expiry');

    // Reports
    Route::get('reports/stock-value', [InventoryTransactionController::class, 'stockValueReport'])->name('reports.stock-value');
    Route::get('reports/stock-movement', [InventoryTransactionController::class, 'stockMovementReport'])->name('reports.stock-movement');
    Route::get('reports/low-stock', [InventoryTransactionController::class, 'lowStockReport'])->name('reports.low-stock');
    Route::get('reports/expiring-items', [InventoryTransactionController::class, 'expiringItemsReport'])->name('reports.expiring-items');
    Route::get('reports/purchase-orders', [InventoryTransactionController::class, 'purchaseOrdersReport'])->name('reports.purchase-orders');
    Route::get('reports/supplier-performance', [InventoryTransactionController::class, 'supplierPerformanceReport'])->name('reports.supplier-performance');
    Route::get('reports/item-movement', [InventoryItemMovementController::class, 'itemMovementReport'])->name('reports.item-movement');

    // Purchase Invoices
    Route::get('purchase-invoices', [PurchaseInvoiceController::class, 'index'])->name('purchase-invoices.index');
    Route::get('purchase-invoices/create', [PurchaseInvoiceController::class, 'create'])->name('purchase-invoices.create');
    Route::post('purchase-invoices', [PurchaseInvoiceController::class, 'store'])->name('purchase-invoices.store');
    Route::get('purchase-invoices/{purchaseInvoice}', [PurchaseInvoiceController::class, 'show'])->name('purchase-invoices.show');
    Route::get('purchase-invoices/{purchaseInvoice}/edit', [PurchaseInvoiceController::class, 'edit'])->name('purchase-invoices.edit');
    Route::put('purchase-invoices/{purchaseInvoice}', [PurchaseInvoiceController::class, 'update'])->name('purchase-invoices.update');
    Route::delete('purchase-invoices/{purchaseInvoice}', [PurchaseInvoiceController::class, 'destroy'])->name('purchase-invoices.destroy');
    Route::get('purchase-invoices/{purchaseInvoice}/print', [PurchaseInvoiceController::class, 'print'])->name('purchase-invoices.print');
    Route::get('purchase-invoices/create-from-purchase-order/{purchaseOrder}', [PurchaseInvoiceController::class, 'createFromPurchaseOrder'])->name('purchase-invoices.create-from-purchase-order');
    Route::get('purchase-invoices/{purchaseInvoice}/add-payment', [PurchaseInvoiceController::class, 'addPaymentForm'])->name('purchase-invoices.add-payment-form');
    Route::post('purchase-invoices/{purchaseInvoice}/add-payment', [PurchaseInvoiceController::class, 'addPayment'])->name('purchase-invoices.add-payment');

    // Purchase Invoice Payments
    Route::get('purchase-invoice-payments', [PurchaseInvoicePaymentController::class, 'index'])->name('purchase-invoice-payments.index');
    Route::get('purchase-invoice-payments/{payment}', [PurchaseInvoicePaymentController::class, 'show'])->name('purchase-invoice-payments.show');
    Route::get('purchase-invoice-payments/{payment}/edit', [PurchaseInvoicePaymentController::class, 'edit'])->name('purchase-invoice-payments.edit');
    Route::put('purchase-invoice-payments/{payment}', [PurchaseInvoicePaymentController::class, 'update'])->name('purchase-invoice-payments.update');
    Route::delete('purchase-invoice-payments/{payment}', [PurchaseInvoicePaymentController::class, 'destroy'])->name('purchase-invoice-payments.destroy');

    // Purchase Returns
    Route::get('purchase-returns', [PurchaseReturnController::class, 'index'])->name('purchase-returns.index');
    Route::get('purchase-returns/create', [PurchaseReturnController::class, 'create'])->name('purchase-returns.create');
    Route::post('purchase-returns', [PurchaseReturnController::class, 'store'])->name('purchase-returns.store');
    Route::get('purchase-returns/{purchaseReturn}', [PurchaseReturnController::class, 'show'])->name('purchase-returns.show');
    Route::get('purchase-returns/{purchaseReturn}/edit', [PurchaseReturnController::class, 'edit'])->name('purchase-returns.edit');
    Route::put('purchase-returns/{purchaseReturn}', [PurchaseReturnController::class, 'update'])->name('purchase-returns.update');
    Route::delete('purchase-returns/{purchaseReturn}', [PurchaseReturnController::class, 'destroy'])->name('purchase-returns.destroy');
    Route::get('purchase-returns/{purchaseReturn}/print', [PurchaseReturnController::class, 'print'])->name('purchase-returns.print');
    Route::get('purchase-returns/create-from-invoice/{purchaseInvoice}', [PurchaseReturnController::class, 'createFromInvoice'])->name('purchase-returns.create-from-invoice');
});
