<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\InstallationProjectController;
use App\Http\Controllers\ProjectElevatorController;
use App\Http\Controllers\ProjectPhaseController;
use App\Http\Controllers\ProjectTaskController;
use App\Http\Controllers\ProjectTeamMemberController;
use App\Http\Controllers\ProjectDocumentController;
use App\Http\Controllers\ProjectExpenseController;
use App\Http\Controllers\ProjectPaymentController;
use App\Http\Controllers\ProjectIssueController;
use App\Http\Controllers\ProjectMilestoneController;
use App\Http\Controllers\ProjectChecklistController;
use App\Http\Controllers\ProjectRiskController;
use App\Http\Controllers\ProjectResourceController;
use App\Http\Controllers\ProjectReportController;
use App\Http\Controllers\ProjectGanttController;
use App\Http\Controllers\ProjectInventoryRequestController;
use App\Http\Controllers\ElevatorStageController;

// مسارات المشاريع
Route::middleware(['auth', 'verified', 'active'])->group(function () {
    // المشاريع
    Route::get('installation-projects', [InstallationProjectController::class, 'index'])->name('installation-projects.index');
    Route::get('installation-projects/create', [InstallationProjectController::class, 'create'])->name('installation-projects.create');
    Route::post('installation-projects', [InstallationProjectController::class, 'store'])->name('installation-projects.store');
    Route::get('installation-projects/{installationProject}', [InstallationProjectController::class, 'show'])->name('installation-projects.show');
    Route::get('installation-projects/{installationProject}/edit', [InstallationProjectController::class, 'edit'])->name('installation-projects.edit');
    Route::put('installation-projects/{installationProject}', [InstallationProjectController::class, 'update'])->name('installation-projects.update');
    Route::delete('installation-projects/{installationProject}', [InstallationProjectController::class, 'destroy'])->name('installation-projects.destroy');
    Route::get('installation-projects/{installationProject}/dashboard', [InstallationProjectController::class, 'dashboard'])->name('installation-projects.dashboard');
    Route::get('installation-projects/{installationProject}/gantt', [InstallationProjectController::class, 'ganttChart'])->name('installation-projects.gantt');
    // مسار بديل للتعامل مع حالات الخطأ في مخطط جانت
    Route::get('installation-projects/gantt/{id}', [InstallationProjectController::class, 'ganttChartSafe'])->name('installation-projects.gantt.safe');

    // مصاعد المشروع
    Route::get('installation-projects/{installationProject}/elevators', [ProjectElevatorController::class, 'index'])->name('installation-projects.elevators.index');
    Route::get('installation-projects/{installationProject}/elevators/create', [ProjectElevatorController::class, 'create'])->name('installation-projects.elevators.create');
    Route::post('installation-projects/{installationProject}/elevators', [ProjectElevatorController::class, 'store'])->name('installation-projects.elevators.store');
    Route::get('installation-projects/{installationProject}/elevators/{projectElevator}', [ProjectElevatorController::class, 'show'])->name('installation-projects.elevators.show');
    Route::get('installation-projects/{installationProject}/elevators/{projectElevator}/edit', [ProjectElevatorController::class, 'edit'])->name('installation-projects.elevators.edit');
    Route::put('installation-projects/{installationProject}/elevators/{projectElevator}', [ProjectElevatorController::class, 'update'])->name('installation-projects.elevators.update');
    Route::delete('installation-projects/{installationProject}/elevators/{projectElevator}', [ProjectElevatorController::class, 'destroy'])->name('installation-projects.elevators.destroy');
    Route::put('installation-projects/{installationProject}/elevators/{projectElevator}/status', [ProjectElevatorController::class, 'updateStatus'])->name('installation-projects.elevators.update-status');

    // جميع مراحل المشاريع
    Route::get('all-project-phases', [App\Http\Controllers\AllProjectPhasesController::class, 'index'])->name('all-project-phases.index');

    // مراحل المصاعد
    Route::resource('elevator-stages', ElevatorStageController::class);

    // جميع مهام المشاريع
    Route::get('all-project-tasks', [App\Http\Controllers\AllProjectTasksController::class, 'index'])->name('all-project-tasks.index');
    Route::get('all-project-tasks/create', [App\Http\Controllers\AllProjectTasksController::class, 'create'])->name('all-project-tasks.create');
    Route::post('all-project-tasks', [App\Http\Controllers\AllProjectTasksController::class, 'store'])->name('all-project-tasks.store');
    Route::get('all-project-tasks/{task}', [App\Http\Controllers\AllProjectTasksController::class, 'show'])->name('all-project-tasks.show');
    Route::get('all-project-tasks/{task}/edit', [App\Http\Controllers\AllProjectTasksController::class, 'edit'])->name('all-project-tasks.edit');
    Route::put('all-project-tasks/{task}', [App\Http\Controllers\AllProjectTasksController::class, 'update'])->name('all-project-tasks.update');
    Route::delete('all-project-tasks/{task}', [App\Http\Controllers\AllProjectTasksController::class, 'destroy'])->name('all-project-tasks.destroy');
    Route::put('all-project-tasks/{task}/progress', [App\Http\Controllers\AllProjectTasksController::class, 'updateProgress'])->name('all-project-tasks.update-progress');
    Route::put('all-project-tasks/{task}/assign', [App\Http\Controllers\AllProjectTasksController::class, 'assignTask'])->name('all-project-tasks.assign');

    // مراحل المشروع
    Route::get('installation-projects/{installationProject}/phases', [ProjectPhaseController::class, 'index'])->name('installation-projects.phases.index');
    Route::get('installation-projects/{installationProject}/phases/create', [ProjectPhaseController::class, 'create'])->name('installation-projects.phases.create');
    Route::post('installation-projects/{installationProject}/phases', [ProjectPhaseController::class, 'store'])->name('installation-projects.phases.store');
    Route::get('installation-projects/{installationProject}/phases/{phase}', [ProjectPhaseController::class, 'show'])->name('installation-projects.phases.show');
    Route::get('installation-projects/{installationProject}/phases/{phase}/edit', [ProjectPhaseController::class, 'edit'])->name('installation-projects.phases.edit');
    Route::put('installation-projects/{installationProject}/phases/{phase}', [ProjectPhaseController::class, 'update'])->name('installation-projects.phases.update');
    Route::delete('installation-projects/{installationProject}/phases/{phase}', [ProjectPhaseController::class, 'destroy'])->name('installation-projects.phases.destroy');
    Route::put('installation-projects/{installationProject}/phases/{phase}/progress', [ProjectPhaseController::class, 'updateProgress'])->name('installation-projects.phases.update-progress');

    // مهام المشروع
    Route::get('installation-projects/{installationProject}/phases/{phase}/tasks', [ProjectTaskController::class, 'index'])->name('installation-projects.phases.tasks.index');
    Route::get('installation-projects/{installationProject}/phases/{phase}/tasks/create', [ProjectTaskController::class, 'create'])->name('installation-projects.phases.tasks.create');
    Route::post('installation-projects/{installationProject}/phases/{phase}/tasks', [ProjectTaskController::class, 'store'])->name('installation-projects.phases.tasks.store');
    Route::get('installation-projects/{installationProject}/phases/{phase}/tasks/{task}', [ProjectTaskController::class, 'show'])->name('installation-projects.phases.tasks.show');
    Route::get('installation-projects/{installationProject}/phases/{phase}/tasks/{task}/edit', [ProjectTaskController::class, 'edit'])->name('installation-projects.phases.tasks.edit');
    Route::put('installation-projects/{installationProject}/phases/{phase}/tasks/{task}', [ProjectTaskController::class, 'update'])->name('installation-projects.phases.tasks.update');
    Route::delete('installation-projects/{installationProject}/phases/{phase}/tasks/{task}', [ProjectTaskController::class, 'destroy'])->name('installation-projects.phases.tasks.destroy');
    Route::put('installation-projects/{installationProject}/phases/{phase}/tasks/{task}/progress', [ProjectTaskController::class, 'updateProgress'])->name('installation-projects.phases.tasks.update-progress');
    Route::put('installation-projects/{installationProject}/phases/{phase}/tasks/{task}/assign', [ProjectTaskController::class, 'assignTask'])->name('installation-projects.phases.tasks.assign');

    // مستندات المشروع
    Route::get('installation-projects/{project_id}/documents', [ProjectDocumentController::class, 'index'])->name('installation-projects.documents.index');
    Route::get('installation-projects/{project_id}/documents/create', [ProjectDocumentController::class, 'create'])->name('installation-projects.documents.create');
    Route::post('installation-projects/{project_id}/documents', [ProjectDocumentController::class, 'store'])->name('installation-projects.documents.store');
    Route::get('installation-projects/{project_id}/documents/{document}', [ProjectDocumentController::class, 'show'])->name('installation-projects.documents.show');
    Route::get('installation-projects/{project_id}/documents/{document}/edit', [ProjectDocumentController::class, 'edit'])->name('installation-projects.documents.edit');
    Route::put('installation-projects/{project_id}/documents/{document}', [ProjectDocumentController::class, 'update'])->name('installation-projects.documents.update');
    Route::delete('installation-projects/{project_id}/documents/{document}', [ProjectDocumentController::class, 'destroy'])->name('installation-projects.documents.destroy');
    Route::get('installation-projects/{project_id}/documents/{document}/download', [ProjectDocumentController::class, 'download'])->name('installation-projects.documents.download');

    // مصروفات المشروع
    Route::get('installation-projects/{project_id}/expenses', [ProjectExpenseController::class, 'index'])->name('installation-projects.expenses.index');
    Route::get('installation-projects/{project_id}/expenses/create', [ProjectExpenseController::class, 'create'])->name('installation-projects.expenses.create');
    Route::post('installation-projects/{project_id}/expenses', [ProjectExpenseController::class, 'store'])->name('installation-projects.expenses.store');
    Route::get('installation-projects/{project_id}/expenses/{expense}', [ProjectExpenseController::class, 'show'])->name('installation-projects.expenses.show');
    Route::get('installation-projects/{project_id}/expenses/{expense}/edit', [ProjectExpenseController::class, 'edit'])->name('installation-projects.expenses.edit');
    Route::put('installation-projects/{project_id}/expenses/{expense}', [ProjectExpenseController::class, 'update'])->name('installation-projects.expenses.update');
    Route::delete('installation-projects/{project_id}/expenses/{expense}', [ProjectExpenseController::class, 'destroy'])->name('installation-projects.expenses.destroy');
    Route::put('installation-projects/{project_id}/expenses/{expense}/approve', [ProjectExpenseController::class, 'approve'])->name('installation-projects.expenses.approve');
    Route::put('installation-projects/{project_id}/expenses/{expense}/reject', [ProjectExpenseController::class, 'reject'])->name('installation-projects.expenses.reject');

    // مدفوعات المشروع
    Route::get('installation-projects/{project_id}/payments', [ProjectPaymentController::class, 'index'])->name('installation-projects.payments.index');
    Route::get('installation-projects/{project_id}/payments/create', [ProjectPaymentController::class, 'create'])->name('installation-projects.payments.create');
    Route::post('installation-projects/{project_id}/payments', [ProjectPaymentController::class, 'store'])->name('installation-projects.payments.store');
    Route::get('installation-projects/{project_id}/payments/{payment}', [ProjectPaymentController::class, 'show'])->name('installation-projects.payments.show');
    Route::get('installation-projects/{project_id}/payments/{payment}/edit', [ProjectPaymentController::class, 'edit'])->name('installation-projects.payments.edit');
    Route::put('installation-projects/{project_id}/payments/{payment}', [ProjectPaymentController::class, 'update'])->name('installation-projects.payments.update');
    Route::delete('installation-projects/{project_id}/payments/{payment}', [ProjectPaymentController::class, 'destroy'])->name('installation-projects.payments.destroy');
    Route::put('installation-projects/{project_id}/payments/{payment}/approve', [ProjectPaymentController::class, 'approve'])->name('installation-projects.payments.approve');
    Route::put('installation-projects/{project_id}/payments/{payment}/reject', [ProjectPaymentController::class, 'reject'])->name('installation-projects.payments.reject');

    // مخاطر المشروع
    Route::get('installation-projects/{installationProject}/risks', [ProjectRiskController::class, 'index'])->name('installation-projects.risks.index');
    Route::get('installation-projects/{installationProject}/risks/create', [ProjectRiskController::class, 'create'])->name('installation-projects.risks.create');
    Route::post('installation-projects/{installationProject}/risks', [ProjectRiskController::class, 'store'])->name('installation-projects.risks.store');
    Route::get('installation-projects/{installationProject}/risks/{risk}', [ProjectRiskController::class, 'show'])->name('installation-projects.risks.show');
    Route::get('installation-projects/{installationProject}/risks/{risk}/edit', [ProjectRiskController::class, 'edit'])->name('installation-projects.risks.edit');
    Route::put('installation-projects/{installationProject}/risks/{risk}', [ProjectRiskController::class, 'update'])->name('installation-projects.risks.update');
    Route::delete('installation-projects/{installationProject}/risks/{risk}', [ProjectRiskController::class, 'destroy'])->name('installation-projects.risks.destroy');
    Route::get('installation-projects/{installationProject}/risks-dashboard', [ProjectRiskController::class, 'dashboard'])->name('installation-projects.risks.dashboard');

    // موارد المشروع
    Route::get('installation-projects/{installationProject}/resources', [ProjectResourceController::class, 'index'])->name('installation-projects.resources.index');
    Route::get('installation-projects/{installationProject}/resources/create', [ProjectResourceController::class, 'create'])->name('installation-projects.resources.create');
    Route::post('installation-projects/{installationProject}/resources', [ProjectResourceController::class, 'store'])->name('installation-projects.resources.store');
    Route::get('installation-projects/{installationProject}/resources/{resource}', [ProjectResourceController::class, 'show'])->name('installation-projects.resources.show');
    Route::get('installation-projects/{installationProject}/resources/{resource}/edit', [ProjectResourceController::class, 'edit'])->name('installation-projects.resources.edit');
    Route::put('installation-projects/{installationProject}/resources/{resource}', [ProjectResourceController::class, 'update'])->name('installation-projects.resources.update');
    Route::delete('installation-projects/{installationProject}/resources/{resource}', [ProjectResourceController::class, 'destroy'])->name('installation-projects.resources.destroy');
    Route::get('installation-projects/{installationProject}/resources/{resource}/allocate', [ProjectResourceController::class, 'allocateForm'])->name('installation-projects.resources.allocate-form');
    Route::post('installation-projects/{installationProject}/resources/{resource}/allocate', [ProjectResourceController::class, 'allocate'])->name('installation-projects.resources.allocate');
    Route::delete('installation-projects/{installationProject}/resources/{resource}/allocations/{allocation}', [ProjectResourceController::class, 'deallocate'])->name('installation-projects.resources.deallocate');
    Route::get('installation-projects/{installationProject}/resources-report', [ProjectResourceController::class, 'report'])->name('installation-projects.resources.report');

    // تقارير المشروع
    Route::get('installation-projects/{installationProject}/reports', [ProjectReportController::class, 'index'])->name('installation-projects.reports.index');
    Route::get('installation-projects/{installationProject}/reports/create', [ProjectReportController::class, 'create'])->name('installation-projects.reports.create');
    Route::post('installation-projects/{installationProject}/reports', [ProjectReportController::class, 'store'])->name('installation-projects.reports.store');

    // طلبات المخزون للمشروع
    Route::get('projects/{projectId}/inventory', [ProjectInventoryRequestController::class, 'index'])->name('projects.inventory.index');
    Route::get('projects/{projectId}/inventory/create', [ProjectInventoryRequestController::class, 'create'])->name('projects.inventory.create');
    Route::post('projects/{projectId}/inventory', [ProjectInventoryRequestController::class, 'store'])->name('projects.inventory.store');
    Route::get('projects/{projectId}/inventory/{requestId}', [ProjectInventoryRequestController::class, 'show'])->name('projects.inventory.show');
    Route::get('projects/{projectId}/inventory/{requestId}/edit', [ProjectInventoryRequestController::class, 'edit'])->name('projects.inventory.edit');
    Route::put('projects/{projectId}/inventory/{requestId}', [ProjectInventoryRequestController::class, 'update'])->name('projects.inventory.update');
    Route::delete('projects/{projectId}/inventory/{requestId}', [ProjectInventoryRequestController::class, 'destroy'])->name('projects.inventory.destroy');
    Route::put('projects/{projectId}/inventory/{requestId}/approve', [ProjectInventoryRequestController::class, 'approve'])->name('projects.inventory.approve');
    Route::put('projects/{projectId}/inventory/{requestId}/reject', [ProjectInventoryRequestController::class, 'reject'])->name('projects.inventory.reject');
    Route::put('projects/{projectId}/inventory/{requestId}/fulfill', [ProjectInventoryRequestController::class, 'fulfill'])->name('projects.inventory.fulfill');
    Route::get('inventory/check-availability', [ProjectInventoryRequestController::class, 'checkAvailability'])->name('inventory.check-availability');
    Route::get('installation-projects/{installationProject}/reports/{report}', [ProjectReportController::class, 'show'])->name('installation-projects.reports.show');
    Route::delete('installation-projects/{installationProject}/reports/{report}', [ProjectReportController::class, 'destroy'])->name('installation-projects.reports.destroy');
    Route::get('installation-projects/{installationProject}/reports/{report}/download', [ProjectReportController::class, 'download'])->name('installation-projects.reports.download');
    Route::get('installation-projects/{installationProject}/reports-dashboard', [ProjectReportController::class, 'dashboard'])->name('installation-projects.reports.dashboard');

    // مخطط جانت
    Route::get('installation-projects/{installationProject}/gantt-chart', [ProjectGanttController::class, 'index'])->name('installation-projects.gantt.index');
    Route::post('installation-projects/{installationProject}/gantt-chart/update-task', [ProjectGanttController::class, 'updateTask'])->name('installation-projects.gantt.update-task');
    Route::post('installation-projects/{installationProject}/gantt-chart/add-dependency', [ProjectGanttController::class, 'addDependency'])->name('installation-projects.gantt.add-dependency');
    Route::delete('installation-projects/{installationProject}/gantt-chart/remove-dependency', [ProjectGanttController::class, 'removeDependency'])->name('installation-projects.gantt.remove-dependency');
    Route::get('installation-projects/{installationProject}/critical-path', [ProjectGanttController::class, 'criticalPath'])->name('installation-projects.gantt.critical-path');
});
