<?php

use App\Http\Controllers\HRM\TrainingController;
use App\Http\Controllers\HRM\CertificateController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| HRM Training Routes
|--------------------------------------------------------------------------
|
| هنا يتم تعريف مسارات نظام التدريب والشهادات
|
*/

// مسارات التدريب
Route::group(['prefix' => 'hrm/trainings', 'as' => 'hrm.trainings.', 'middleware' => ['auth', 'company']], function () {
    Route::get('/', [TrainingController::class, 'index'])->name('index');
    Route::get('/create', [TrainingController::class, 'create'])->name('create');
    Route::post('/', [TrainingController::class, 'store'])->name('store');
    Route::get('/{id}', [TrainingController::class, 'show'])->name('show');
    Route::get('/{id}/edit', [TrainingController::class, 'edit'])->name('edit');
    Route::put('/{id}', [TrainingController::class, 'update'])->name('update');
    Route::delete('/{id}', [TrainingController::class, 'destroy'])->name('destroy');

    // مسارات المشاركين في التدريب
    Route::put('/{id}/participants/{participantId}', [TrainingController::class, 'updateParticipantStatus'])->name('participants.update');
    Route::post('/{id}/participants/{participantId}/certificate', [TrainingController::class, 'issueCertificate'])->name('participants.certificate');
});

// مسارات الشهادات
Route::group(['prefix' => 'hrm/certificates', 'as' => 'hrm.certificates.', 'middleware' => ['auth', 'company']], function () {
    Route::get('/', [CertificateController::class, 'index'])->name('index');
    Route::get('/create', [CertificateController::class, 'create'])->name('create');
    Route::post('/', [CertificateController::class, 'store'])->name('store');
    Route::get('/{id}', [CertificateController::class, 'show'])->name('show');
    Route::get('/{id}/edit', [CertificateController::class, 'edit'])->name('edit');
    Route::put('/{id}', [CertificateController::class, 'update'])->name('update');
    Route::delete('/{id}', [CertificateController::class, 'destroy'])->name('destroy');
    Route::get('/{id}/download', [CertificateController::class, 'downloadCertificate'])->name('download');
    Route::get('/expiring-soon', [CertificateController::class, 'expiringSoon'])->name('expiring');
});
