<?php

use App\Http\Controllers\HRM\EmployeeTaskController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| HRM Tasks Routes
|--------------------------------------------------------------------------
|
| هنا يتم تعريف مسارات نظام مهام الموظفين
|
*/

// مسارات المهام
Route::group(['prefix' => 'hrm/tasks', 'as' => 'hrm.tasks.', 'middleware' => ['auth', 'company']], function () {
    Route::get('/', [EmployeeTaskController::class, 'index'])->name('index');
    Route::get('/create', [EmployeeTaskController::class, 'create'])->name('create');
    Route::post('/', [EmployeeTaskController::class, 'store'])->name('store');
    Route::get('/{id}', [EmployeeTaskController::class, 'show'])->name('show');
    Route::get('/{id}/edit', [EmployeeTaskController::class, 'edit'])->name('edit');
    Route::put('/{id}', [EmployeeTaskController::class, 'update'])->name('update');
    Route::delete('/{id}', [EmployeeTaskController::class, 'destroy'])->name('destroy');

    // مسارات المكلفين بالمهام
    Route::put('/{id}/assignees/{assigneeId}', [EmployeeTaskController::class, 'updateAssigneeStatus'])->name('assignees.update');

    // مسارات التعليقات
    Route::post('/{id}/comments', [EmployeeTaskController::class, 'addComment'])->name('comments.add');
    Route::delete('/{id}/comments/{commentId}', [EmployeeTaskController::class, 'deleteComment'])->name('comments.delete');

    // مسارات المرفقات
    Route::post('/{id}/attachments', [EmployeeTaskController::class, 'addAttachment'])->name('attachments.add');
    Route::delete('/{id}/attachments/{attachmentId}', [EmployeeTaskController::class, 'deleteAttachment'])->name('attachments.delete');
    Route::get('/{id}/attachments/{attachmentId}/download', [EmployeeTaskController::class, 'downloadAttachment'])->name('attachments.download');

    // مسارات خاصة
    Route::get('/overdue', [EmployeeTaskController::class, 'overdueTasks'])->name('overdue');
    Route::get('/upcoming', [EmployeeTaskController::class, 'upcomingTasks'])->name('upcoming');
    Route::get('/dashboard', [EmployeeTaskController::class, 'dashboard'])->name('dashboard');
});
