<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FinancialReportController;
use App\Http\Controllers\TaxReportController;
use App\Http\Controllers\CustomerStatementController;

/*
|--------------------------------------------------------------------------
| Financial Reports Routes
|--------------------------------------------------------------------------
|
| Here is where you can register financial reports related routes for your application.
|
*/

// Financial Reports
Route::prefix('financial-reports')->name('financial-reports.')->middleware(['auth', 'verified'])->group(function () {
    // Main index
    Route::get('/', [FinancialReportController::class, 'index'])->name('index');

    // Income & Expense Reports
    Route::get('/income-expense/form', [FinancialReportController::class, 'incomeExpenseForm'])->name('income-expense-form');
    Route::post('/income-expense', [FinancialReportController::class, 'incomeExpense'])->name('income-expense');

    // Profitability Reports
    Route::get('/profitability/form', [FinancialReportController::class, 'profitabilityForm'])->name('profitability-form');
    Route::post('/profitability', [FinancialReportController::class, 'profitability'])->name('profitability');

    // Export Reports
    Route::get('/export/{type}', [FinancialReportController::class, 'export'])->name('export');
});

// Tax Reports
Route::prefix('tax-reports')->name('tax-reports.')->middleware(['auth', 'verified'])->group(function () {
    // Main index
    Route::get('/', [TaxReportController::class, 'index'])->name('index');

    // Generate Tax Report
    Route::get('/generate', [TaxReportController::class, 'generateForm'])->name('generate-form');
    Route::post('/generate', [TaxReportController::class, 'generate'])->name('generate');

    // View Tax Report
    Route::get('/{taxReport}', [TaxReportController::class, 'show'])->name('show');

    // Submit Tax Report
    Route::post('/{taxReport}/submit', [TaxReportController::class, 'submit'])->name('submit');

    // Approve Tax Report
    Route::post('/{taxReport}/approve', [TaxReportController::class, 'approve'])->name('approve');

    // Reject Tax Report
    Route::post('/{taxReport}/reject', [TaxReportController::class, 'reject'])->name('reject');

    // Export Tax Report
    Route::get('/{taxReport}/export', [TaxReportController::class, 'export'])->name('export');
});

// Customer Statements
Route::prefix('customer-statements')->name('customer-statements.')->middleware(['auth', 'verified'])->group(function () {
    // Main index
    Route::get('/', [CustomerStatementController::class, 'index'])->name('index');

    // Generate Customer Statement
    Route::get('/generate', [CustomerStatementController::class, 'generateForm'])->name('generate-form');
    Route::post('/generate', [CustomerStatementController::class, 'generate'])->name('generate');

    // Export Customer Statement
    Route::get('/{customer}/export', [CustomerStatementController::class, 'export'])->name('export');
});
