<?php

use App\Http\Controllers\ElevatorReportController;
use App\Http\Controllers\MaintenanceElevatorsReportController;
use App\Http\Controllers\ElevatorWarrantyReportController;
use App\Http\Controllers\ElevatorPaymentReportController;
use Illuminate\Support\Facades\Route;

// طرق تقارير المصاعد
Route::get('elevator-reports', [ElevatorReportController::class, 'index'])->name('elevator-reports.index');
Route::get('elevator-reports/elevator-status', [ElevatorReportController::class, 'elevatorStatus'])->name('elevator-reports.elevator-status');
Route::get('elevator-reports/maintenance', [ElevatorReportController::class, 'maintenanceReport'])->name('elevator-reports.maintenance');
Route::get('elevator-reports/inspection', [ElevatorReportController::class, 'inspectionReport'])->name('elevator-reports.inspection');
Route::get('elevator-reports/by-customer', [ElevatorReportController::class, 'elevatorsByCustomer'])->name('elevator-reports.by-customer');
Route::get('elevator-reports/by-type', [ElevatorReportController::class, 'elevatorsByType'])->name('elevator-reports.by-type');
Route::get('elevator-reports/by-model', [ElevatorReportController::class, 'elevatorsByModel'])->name('elevator-reports.by-model');

// تقرير انتهاء ضمان المصاعد
Route::get('elevator-reports/warranty', [ElevatorWarrantyReportController::class, 'index'])->name('elevator-reports.warranty');

// تقرير كل مصاعد الصيانة
Route::get('elevator-reports/maintenance-elevators', [MaintenanceElevatorsReportController::class, 'index'])->name('elevator-reports.maintenance-elevators');

// تقرير مدفوعات المصاعد قيد التركيب
Route::get('reports/elevator-payments', [ElevatorPaymentReportController::class, 'index'])->name('reports.elevator-payments');
