<?php

use App\Http\Controllers\ElevatorMaintenanceScheduleController;
use App\Http\Controllers\MaintenanceScheduleController;
use Illuminate\Support\Facades\Route;

// NOTA: Las rutas de programaciones de mantenimiento periódicas han sido deshabilitadas
// para evitar la duplicación. Todas las programaciones de mantenimiento deben estar
// vinculadas a contratos de mantenimiento.

// Redirigir todas las rutas de programaciones periódicas a las programaciones vinculadas a contratos
Route::get('elevator-maintenance-schedules', function () {
    return redirect()->route('maintenance-schedules.index')
        ->with('info', 'تم تعطيل جداول الصيانة الدورية. يرجى استخدام جداول الصيانة المرتبطة بالعقود فقط.');
})->name('elevator-maintenance-schedules.index');

Route::get('elevator-maintenance-schedules/create', function () {
    return redirect()->route('maintenance-schedules.create')
        ->with('info', 'تم تعطيل جداول الصيانة الدورية. يرجى إنشاء جداول الصيانة المرتبطة بالعقود فقط.');
})->name('elevator-maintenance-schedules.create');

Route::get('elevator-maintenance-schedules/{id}', function () {
    return redirect()->route('maintenance-schedules.index')
        ->with('info', 'تم تعطيل جداول الصيانة الدورية. يرجى استخدام جداول الصيانة المرتبطة بالعقود فقط.');
})->name('elevator-maintenance-schedules.show');

Route::get('elevator-maintenance-schedules/{id}/edit', function () {
    return redirect()->route('maintenance-schedules.index')
        ->with('info', 'تم تعطيل جداول الصيانة الدورية. يرجى استخدام جداول الصيانة المرتبطة بالعقود فقط.');
})->name('elevator-maintenance-schedules.edit');

// Redirigir la generación de operaciones de mantenimiento
Route::get('elevator-maintenance-schedules/generate', function () {
    return redirect()->route('maintenance-schedules.index')
        ->with('info', 'تم تعطيل جداول الصيانة الدورية. يرجى استخدام جداول الصيانة المرتبطة بالعقود فقط.');
})->name('elevator-maintenance-schedules.generate');
