<?php

use App\Http\Controllers\ElevatorMaintenanceController;
use Illuminate\Support\Facades\Route;

// Elevator Maintenance Routes
Route::get('elevator-maintenance/pending', [ElevatorMaintenanceController::class, 'pending'])->name('elevator-maintenance.pending');
Route::get('elevator-maintenance/completed', [ElevatorMaintenanceController::class, 'completed'])->name('elevator-maintenance.completed');
Route::get('elevator-maintenance/scheduled', [ElevatorMaintenanceController::class, 'scheduled'])->name('elevator-maintenance.scheduled');
Route::get('elevator-maintenance/periodic', [ElevatorMaintenanceController::class, 'periodic'])->name('elevator-maintenance.periodic');
Route::post('elevator-maintenance/{id}/complete', [ElevatorMaintenanceController::class, 'markAsComplete'])->name('elevator-maintenance.complete');
Route::post('elevator-maintenance/{id}/cancel', [ElevatorMaintenanceController::class, 'markAsCancel'])->name('elevator-maintenance.cancel');
Route::get('elevator-maintenance/{id}/print', [ElevatorMaintenanceController::class, 'print'])->name('elevator-maintenance.print');
Route::resource('elevator-maintenance', ElevatorMaintenanceController::class);
