<?php

use App\Http\Controllers\ElevatorInventoryRequestController;
use Illuminate\Support\Facades\Route;

// مسارات طلبات المخزون للمصاعد
Route::middleware(['auth'])->group(function () {
    Route::get('elevator-inventory', [ElevatorInventoryRequestController::class, 'index'])->name('elevator-inventory.index');
    Route::get('elevator-inventory/create', [ElevatorInventoryRequestController::class, 'create'])->name('elevator-inventory.create');
    Route::post('elevator-inventory', [ElevatorInventoryRequestController::class, 'store'])->name('elevator-inventory.store');
    Route::get('elevator-inventory/{elevatorInventoryRequest}', [ElevatorInventoryRequestController::class, 'show'])->name('elevator-inventory.show');
    Route::get('elevator-inventory/{elevatorInventoryRequest}/edit', [ElevatorInventoryRequestController::class, 'edit'])->name('elevator-inventory.edit');
    Route::put('elevator-inventory/{elevatorInventoryRequest}', [ElevatorInventoryRequestController::class, 'update'])->name('elevator-inventory.update');
    Route::delete('elevator-inventory/{elevatorInventoryRequest}', [ElevatorInventoryRequestController::class, 'destroy'])->name('elevator-inventory.destroy');
    Route::patch('elevator-inventory/{elevatorInventoryRequest}/approve', [ElevatorInventoryRequestController::class, 'approve'])->name('elevator-inventory.approve');
    Route::patch('elevator-inventory/{elevatorInventoryRequest}/reject', [ElevatorInventoryRequestController::class, 'reject'])->name('elevator-inventory.reject');
    Route::patch('elevator-inventory/{elevatorInventoryRequest}/fulfill', [ElevatorInventoryRequestController::class, 'fulfill'])->name('elevator-inventory.fulfill');
});
