<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CustomerInteractionController;
use App\Http\Controllers\OpportunityController;
use App\Http\Controllers\MarketingCampaignController;
use App\Http\Controllers\CampaignMemberController;
use App\Http\Controllers\CustomerSurveyController;
use App\Http\Controllers\SurveyResponseController;
use App\Http\Controllers\LoyaltyPointController;
use App\Http\Controllers\CustomerRewardController;
use App\Http\Controllers\RewardRedemptionController;

/*
|--------------------------------------------------------------------------
| مسارات إدارة العملاء
|--------------------------------------------------------------------------
|
| هنا يتم تعريف جميع المسارات المتعلقة بإدارة العملاء والتفاعلات والفرص التجارية
| والحملات التسويقية ونظام الولاء والمكافآت
|
*/

// مسارات التفاعلات مع العملاء
Route::resource('customer-interactions', CustomerInteractionController::class);
Route::get('customer/{customerId}/interactions', [CustomerInteractionController::class, 'customerInteractions'])
    ->name('customer.interactions');
Route::get('customer-interactions/{id}/follow-up', [CustomerInteractionController::class, 'addFollowUp'])
    ->name('customer-interactions.add-follow-up');
Route::post('customer-interactions/{id}/follow-up', [CustomerInteractionController::class, 'storeFollowUp'])
    ->name('customer-interactions.store-follow-up');

// مسارات الفرص التجارية
Route::resource('opportunities', OpportunityController::class);
Route::get('customer/{customerId}/opportunities', [OpportunityController::class, 'customerOpportunities'])
    ->name('customer.opportunities');

// مسارات الحملات التسويقية
Route::resource('marketing-campaigns', MarketingCampaignController::class);
Route::resource('campaign-members', CampaignMemberController::class);
Route::get('campaign/{campaignId}/members', [CampaignMemberController::class, 'campaignMembers'])
    ->name('campaign.members');

// مسارات استبيانات العملاء
Route::resource('customer-surveys', CustomerSurveyController::class);
Route::resource('survey-responses', SurveyResponseController::class);
Route::get('survey/{surveyId}/responses', [SurveyResponseController::class, 'surveyResponses'])
    ->name('survey.responses');
Route::get('customer/{customerId}/surveys', [SurveyResponseController::class, 'customerSurveys'])
    ->name('customer.surveys');

// مسارات نظام الولاء والمكافآت
Route::resource('loyalty-points', LoyaltyPointController::class);
Route::resource('customer-rewards', CustomerRewardController::class);
Route::resource('reward-redemptions', RewardRedemptionController::class);
Route::get('customer/{customerId}/loyalty-points', [LoyaltyPointController::class, 'customerLoyaltyPoints'])
    ->name('customer.loyalty-points');
Route::get('customer/{customerId}/reward-redemptions', [RewardRedemptionController::class, 'customerRedemptions'])
    ->name('customer.reward-redemptions');
