<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| Console Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of your Closure based console
| commands. Each Closure is bound to a command instance allowing a
| simple approach to interacting with each command's IO methods.
|
*/

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

// أمر لتشغيل فحص الصيانة المستحقة يدوياً
Artisan::command('maintenance:check-now', function () {
    $this->info('بدء فحص جداول الصيانة...');

    try {
        Artisan::call('maintenance:check-schedules');
        $output = Artisan::output();

        $this->info('تم فحص جداول الصيانة بنجاح!');
        $this->comment($output);
    } catch (\Exception $e) {
        $this->error('حدث خطأ أثناء فحص جداول الصيانة: ' . $e->getMessage());
    }
})->purpose('فحص جداول الصيانة المستحقة والمتأخرة وإرسال الإشعارات');

// أمر لتشغيل بذر صلاحيات الإشعارات
Artisan::command('permissions:seed-all', function () {
    $this->info('بدء بذر جميع الصلاحيات...');

    try {
        // بذر الصلاحيات الأساسية
        Artisan::call('db:seed', [
            '--class' => 'Database\\Seeders\\PermissionsSeeder',
            '--force' => true
        ]);

        // بذر صلاحيات الصيانة
        Artisan::call('db:seed', [
            '--class' => 'Database\\Seeders\\MaintenancePermissionsSeeder',
            '--force' => true
        ]);

        // بذر صلاحيات CRM
        Artisan::call('db:seed', [
            '--class' => 'Database\\Seeders\\CrmPermissionsSeeder',
            '--force' => true
        ]);

        // بذر صلاحيات الإشعارات
        Artisan::call('db:seed', [
            '--class' => 'Database\\Seeders\\NotificationPermissionsSeeder',
            '--force' => true
        ]);

        $this->info('تم بذر جميع الصلاحيات بنجاح!');
    } catch (\Exception $e) {
        $this->error('حدث خطأ أثناء بذر الصلاحيات: ' . $e->getMessage());
    }
})->purpose('بذر جميع الصلاحيات وتعيينها للأدوار');
