<?php

use App\Http\Controllers\CompanySettingController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| إعدادات الشركة
|--------------------------------------------------------------------------
|
| هنا يتم تعريف مسارات إعدادات الشركة في النظام
|
*/

Route::middleware(['auth'])->group(function () {
    // مسارات إعدادات الشركة
    Route::get('/company-settings', [CompanySettingController::class, 'index'])->name('company_settings.index');
    Route::get('/company-settings/edit', [CompanySettingController::class, 'edit'])->name('company_settings.edit');
    Route::post('/company-settings/update', [CompanySettingController::class, 'update'])->name('company_settings.update');
    Route::post('/company-settings/upload-logo', [CompanySettingController::class, 'uploadLogo'])->name('company_settings.upload_logo');
});
