<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CivilDefenseTerminationLetterController;

// Civil Defense Termination Letters Routes
Route::prefix('civil-defense')->name('civil-defense.')->middleware(['auth'])->group(function () {
    // Termination Letters
    Route::get('termination-letters', [CivilDefenseTerminationLetterController::class, 'index'])
        ->name('termination-letters.index');
    Route::get('termination-letters/create', [CivilDefenseTerminationLetterController::class, 'create'])
        ->name('termination-letters.create');
    Route::post('termination-letters', [CivilDefenseTerminationLetterController::class, 'store'])
        ->name('termination-letters.store');
    Route::get('termination-letters/{letter}', [CivilDefenseTerminationLetterController::class, 'show'])
        ->name('termination-letters.show');
    Route::get('termination-letters/{letter}/edit', [CivilDefenseTerminationLetterController::class, 'edit'])
        ->name('termination-letters.edit');
    Route::put('termination-letters/{letter}', [CivilDefenseTerminationLetterController::class, 'update'])
        ->name('termination-letters.update');
    Route::delete('termination-letters/{letter}', [CivilDefenseTerminationLetterController::class, 'destroy'])
        ->name('termination-letters.destroy');
    Route::get('termination-letters/{letter}/print', [CivilDefenseTerminationLetterController::class, 'print'])
        ->name('termination-letters.print');

    // AJAX route to get customer information for the selected elevator
    Route::get('get-customer-info', [CivilDefenseTerminationLetterController::class, 'getCustomerInfo'])
        ->name('get-customer-info')->withoutMiddleware(['permission:view_termination_letters', 'permission:manage_termination_letters']);
});
