<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CashRegisterController;
use App\Http\Controllers\CashTransactionController;
use App\Http\Controllers\CashReportController;

/*
|--------------------------------------------------------------------------
| Cash Registers Routes
|--------------------------------------------------------------------------
|
| Here is where you can register cash registers related routes for your application.
|
*/

// مسارات الخزائن
Route::group(['middleware' => ['auth']], function () {
    // مسارات إدارة الخزائن
    Route::get('cash-registers', [CashRegisterController::class, 'index'])->name('cash-registers.index')->middleware('permission:view_cash_registers');
    Route::get('cash-registers/create', [CashRegisterController::class, 'create'])->name('cash-registers.create')->middleware('permission:create_cash_registers');
    Route::post('cash-registers', [CashRegisterController::class, 'store'])->name('cash-registers.store')->middleware('permission:create_cash_registers');
    Route::get('cash-registers/{cashRegister}', [CashRegisterController::class, 'show'])->name('cash-registers.show')->middleware('permission:view_cash_registers');
    Route::get('cash-registers/{cashRegister}/edit', [CashRegisterController::class, 'edit'])->name('cash-registers.edit')->middleware('permission:edit_cash_registers');
    Route::put('cash-registers/{cashRegister}', [CashRegisterController::class, 'update'])->name('cash-registers.update')->middleware('permission:edit_cash_registers');
    Route::delete('cash-registers/{cashRegister}', [CashRegisterController::class, 'destroy'])->name('cash-registers.destroy')->middleware('permission:delete_cash_registers');

    // مسارات معاملات الخزائن
    Route::get('cash-transactions', [CashTransactionController::class, 'index'])->name('cash-transactions.index')->middleware('permission:view_cash_transactions');
    Route::get('cash-transactions/create', [CashTransactionController::class, 'create'])->name('cash-transactions.create')->middleware('permission:create_cash_transactions');
    Route::post('cash-transactions', [CashTransactionController::class, 'store'])->name('cash-transactions.store')->middleware('permission:create_cash_transactions');
    Route::get('cash-transactions/{cashTransaction}', [CashTransactionController::class, 'show'])->name('cash-transactions.show')->middleware('permission:view_cash_transactions');
    Route::delete('cash-transactions/{cashTransaction}', [CashTransactionController::class, 'destroy'])->name('cash-transactions.destroy')->middleware('permission:delete_cash_transactions');

    // مسارات الإيداعات
    Route::get('cash-deposits', [CashTransactionController::class, 'deposits'])->name('cash-deposits.index')->middleware('permission:view_cash_transactions');
    Route::get('cash-deposits/create', [CashTransactionController::class, 'createDepositForm'])->name('cash-deposits.create')->middleware('permission:create_cash_transactions');
    Route::get('cash-deposits/import', [CashTransactionController::class, 'importDepositsForm'])->name('cash-deposits.import.form')->middleware('permission:create_cash_transactions');
    Route::post('cash-deposits/import', [CashTransactionController::class, 'importDeposits'])->name('cash-deposits.import')->middleware('permission:create_cash_transactions');

    // مسارات السحوبات
    Route::get('cash-withdrawals', [CashTransactionController::class, 'withdrawals'])->name('cash-withdrawals.index')->middleware('permission:view_cash_transactions');
    Route::get('cash-withdrawals/create', [CashTransactionController::class, 'createWithdrawalForm'])->name('cash-withdrawals.create')->middleware('permission:create_cash_transactions');

    // مسارات خاصة للمعاملات
    Route::get('cash-registers/{cashRegister}/deposit', [CashTransactionController::class, 'createDeposit'])->name('cash-transactions.create-deposit')->middleware('permission:create_cash_transactions');
    Route::get('cash-registers/{cashRegister}/withdrawal', [CashTransactionController::class, 'createWithdrawal'])->name('cash-transactions.create-withdrawal')->middleware('permission:create_cash_transactions');
    Route::get('cash-registers/{cashRegister}/transfer', [CashTransactionController::class, 'createTransfer'])->name('cash-transactions.create-transfer')->middleware('permission:create_cash_transactions');

    // مسارات تقارير الخزينة
    Route::get('cash-reports', [CashReportController::class, 'index'])->name('cash-reports.index')->middleware('permission:view_cash_reports');
    Route::get('cash-reports/daily-movement', [CashReportController::class, 'dailyMovement'])->name('cash-reports.daily-movement')->middleware('permission:view_cash_reports');
    Route::get('cash-reports/registers-summary', [CashReportController::class, 'cashRegistersSummary'])->name('cash-reports.registers-summary')->middleware('permission:view_cash_reports');
    Route::get('cash-reports/transactions-by-period', [CashReportController::class, 'transactionsByPeriod'])->name('cash-reports.transactions-by-period')->middleware('permission:view_cash_reports');
    Route::get('cash-reports/daily-balance', [CashReportController::class, 'dailyBalance'])->name('cash-reports.daily-balance')->middleware('permission:view_cash_reports');
    Route::post('cash-reports/export-excel', [CashReportController::class, 'exportToExcel'])->name('cash-reports.export-excel')->middleware('permission:view_cash_reports');
});
