<?php

use App\Http\Controllers\BankController;
use App\Http\Controllers\BankAccountController;
use App\Http\Controllers\BankTransactionController;
use App\Http\Controllers\ChequeController;
use App\Http\Controllers\BankReconciliationController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Banking System Routes
|--------------------------------------------------------------------------
|
| Here is where you can register banking system routes for your application.
|
*/

// Bank routes
Route::middleware(['auth', 'active'])->group(function () {
    // Banks
    Route::get('/banks', [BankController::class, 'index'])->name('banks.index');
    Route::get('/banks/create', [BankController::class, 'create'])->name('banks.create');
    Route::post('/banks', [BankController::class, 'store'])->name('banks.store');
    Route::get('/banks/{bank}', [BankController::class, 'show'])->name('banks.show');
    Route::get('/banks/{bank}/edit', [BankController::class, 'edit'])->name('banks.edit');
    Route::put('/banks/{bank}', [BankController::class, 'update'])->name('banks.update');
    Route::delete('/banks/{bank}', [BankController::class, 'destroy'])->name('banks.destroy');

    // Bank Accounts
    Route::get('/bank-accounts', [BankAccountController::class, 'index'])->name('bank-accounts.index');
    Route::get('/bank-accounts/create', [BankAccountController::class, 'create'])->name('bank-accounts.create');
    Route::post('/bank-accounts', [BankAccountController::class, 'store'])->name('bank-accounts.store');
    Route::get('/bank-accounts/{bankAccount}', [BankAccountController::class, 'show'])->name('bank-accounts.show');
    Route::get('/bank-accounts/{bankAccount}/edit', [BankAccountController::class, 'edit'])->name('bank-accounts.edit');
    Route::put('/bank-accounts/{bankAccount}', [BankAccountController::class, 'update'])->name('bank-accounts.update');
    Route::delete('/bank-accounts/{bankAccount}', [BankAccountController::class, 'destroy'])->name('bank-accounts.destroy');
    Route::get('/bank-accounts/{bankAccount}/statement', [BankAccountController::class, 'statement'])->name('bank-accounts.statement');

    // Bank Transactions
    Route::get('/bank-transactions', [BankTransactionController::class, 'index'])->name('bank-transactions.index');
    Route::get('/bank-transactions/deposit/create', [BankTransactionController::class, 'createDeposit'])->name('bank-transactions.create-deposit');
    Route::post('/bank-transactions/deposit', [BankTransactionController::class, 'storeDeposit'])->name('bank-transactions.store-deposit');
    Route::get('/bank-transactions/deposit/{id}/edit', [BankTransactionController::class, 'editDeposit'])->name('bank-transactions.edit-deposit');
    Route::put('/bank-transactions/deposit/{id}', [BankTransactionController::class, 'updateDeposit'])->name('bank-transactions.update-deposit');
    Route::get('/bank-transactions/withdrawal/create', [BankTransactionController::class, 'createWithdrawal'])->name('bank-transactions.create-withdrawal');
    Route::post('/bank-transactions/withdrawal', [BankTransactionController::class, 'storeWithdrawal'])->name('bank-transactions.store-withdrawal');
    Route::get('/bank-transactions/withdrawal/{id}/edit', [BankTransactionController::class, 'editWithdrawal'])->name('bank-transactions.edit-withdrawal');
    Route::put('/bank-transactions/withdrawal/{id}', [BankTransactionController::class, 'updateWithdrawal'])->name('bank-transactions.update-withdrawal');
    Route::get('/bank-transactions/transfer/create', [BankTransactionController::class, 'createTransfer'])->name('bank-transactions.create-transfer');
    Route::post('/bank-transactions/transfer', [BankTransactionController::class, 'storeTransfer'])->name('bank-transactions.store-transfer');
    Route::get('/bank-transactions/{transaction}', [BankTransactionController::class, 'show'])->name('bank-transactions.show');
    Route::delete('/bank-transactions/{transaction}', [BankTransactionController::class, 'destroy'])->name('bank-transactions.destroy');

    // Cheques
    Route::get('/cheques', [ChequeController::class, 'index'])->name('cheques.index');
    Route::get('/cheques/incoming/create', [ChequeController::class, 'createIncoming'])->name('cheques.create-incoming');
    Route::post('/cheques/incoming', [ChequeController::class, 'storeIncoming'])->name('cheques.store-incoming');
    Route::get('/cheques/outgoing/create', [ChequeController::class, 'createOutgoing'])->name('cheques.create-outgoing');
    Route::post('/cheques/outgoing', [ChequeController::class, 'storeOutgoing'])->name('cheques.store-outgoing');
    Route::get('/cheques/{cheque}', [ChequeController::class, 'show'])->name('cheques.show');
    Route::get('/cheques/{cheque}/edit', [ChequeController::class, 'edit'])->name('cheques.edit');
    Route::put('/cheques/{cheque}', [ChequeController::class, 'update'])->name('cheques.update');
    Route::post('/cheques/{cheque}/process', [ChequeController::class, 'process'])->name('cheques.process');
    Route::delete('/cheques/{cheque}', [ChequeController::class, 'destroy'])->name('cheques.destroy');

    // Bank Reconciliations
    Route::get('/bank-reconciliations', [BankReconciliationController::class, 'index'])->name('bank-reconciliations.index');
    Route::get('/bank-reconciliations/create', [BankReconciliationController::class, 'create'])->name('bank-reconciliations.create');
    Route::post('/bank-reconciliations', [BankReconciliationController::class, 'store'])->name('bank-reconciliations.store');
    Route::get('/bank-reconciliations/{reconciliation}', [BankReconciliationController::class, 'show'])->name('bank-reconciliations.show');
    Route::get('/bank-reconciliations/{reconciliation}/edit', [BankReconciliationController::class, 'edit'])->name('bank-reconciliations.edit');
    Route::put('/bank-reconciliations/{reconciliation}', [BankReconciliationController::class, 'update'])->name('bank-reconciliations.update');
    Route::post('/bank-reconciliations/{reconciliation}/add-transaction', [BankReconciliationController::class, 'addTransaction'])->name('bank-reconciliations.add-transaction');
    Route::post('/bank-reconciliations/{reconciliation}/remove-transaction', [BankReconciliationController::class, 'removeTransaction'])->name('bank-reconciliations.remove-transaction');
    Route::post('/bank-reconciliations/{reconciliation}/complete', [BankReconciliationController::class, 'complete'])->name('bank-reconciliations.complete');
    Route::post('/bank-reconciliations/{reconciliation}/cancel', [BankReconciliationController::class, 'cancel'])->name('bank-reconciliations.cancel');
    Route::delete('/bank-reconciliations/{reconciliation}', [BankReconciliationController::class, 'destroy'])->name('bank-reconciliations.destroy');
});
